/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor;

import io.quarkus.security.runtime.interceptor.SecurityConstrainer;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.interceptor.InvocationContext;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

@Singleton
public class SecurityHandler {
    @Inject
    SecurityConstrainer constrainer;

    public Object handle(InvocationContext ic) throws Exception {
        if (this.alreadyHandled(ic)) {
            return ic.proceed();
        }
        Class<?> returnType = ic.getMethod().getReturnType();
        if (Uni.class.isAssignableFrom(returnType)) {
            return this.constrainer.nonBlockingCheck(ic.getMethod(), ic.getParameters()).onItem().transformToUni(new UniContinuation(ic));
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.constrainer.nonBlockingCheck(ic.getMethod(), ic.getParameters()).onItem().transformToUni(s -> {
                try {
                    return Uni.createFrom().completionStage((CompletionStage)ic.proceed());
                }
                catch (Exception e) {
                    return Uni.createFrom().failure(e);
                }
            }).subscribeAsCompletionStage();
        }
        if (Multi.class.isAssignableFrom(returnType)) {
            return this.constrainer.nonBlockingCheck(ic.getMethod(), ic.getParameters()).onItem().transformToMulti(new MultiContinuation(ic));
        }
        this.constrainer.check(ic.getMethod(), ic.getParameters());
        return ic.proceed();
    }

    private boolean alreadyHandled(InvocationContext ic) {
        return ic.getContextData().put("io.quarkus.security.securityHandler", "executed") != null;
    }

    private static class UniContinuation
    implements Function<Object, Uni<?>> {
        private final InvocationContext ic;

        UniContinuation(InvocationContext invocationContext) {
            this.ic = invocationContext;
        }

        @Override
        public Uni<?> apply(Object o) {
            try {
                return (Uni)this.ic.proceed();
            }
            catch (Exception e) {
                return Uni.createFrom().failure(e);
            }
        }
    }

    private static class MultiContinuation
    implements Function<Object, Multi<?>> {
        private final InvocationContext ic;

        public MultiContinuation(InvocationContext invocationContext) {
            this.ic = invocationContext;
        }

        @Override
        public Multi<?> apply(Object o) {
            try {
                return (Multi)this.ic.proceed();
            }
            catch (Exception e) {
                return Multi.createFrom().failure(e);
            }
        }
    }
}

