/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi.runtime;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthenticationFailureEvent;
import io.quarkus.security.spi.runtime.AuthenticationSuccessEvent;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityEvent;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;

public class SecurityEventHelper<S extends SecurityEvent, F extends SecurityEvent> {
    public static final AuthorizationFailureEvent AUTHORIZATION_FAILURE = new AuthorizationFailureEvent(null, null, null);
    public static final AuthorizationSuccessEvent AUTHORIZATION_SUCCESS = new AuthorizationSuccessEvent(null, null);
    public static final AuthenticationFailureEvent AUTHENTICATION_FAILURE = new AuthenticationFailureEvent(null, null);
    public static final AuthenticationSuccessEvent AUTHENTICATION_SUCCESS = new AuthenticationSuccessEvent(null, null);
    private final boolean fireEventOnSuccess;
    private final boolean fireEventOnFailure;
    private final Event<S> successEvent;
    private final Event<F> failureEvent;

    public SecurityEventHelper(Event<S> successEvent, Event<F> failureEvent, S successInstance, F failureInstance, BeanManager beanManager, boolean enabled) {
        if (enabled) {
            boolean fireAllSecurityEvents;
            boolean bl = fireAllSecurityEvents = !beanManager.resolveObserverMethods(new SecurityEvent(){

                @Override
                public SecurityIdentity getSecurityIdentity() {
                    return null;
                }

                @Override
                public Map<String, Object> getEventProperties() {
                    return Map.of();
                }
            }, new Annotation[0]).isEmpty();
            if (fireAllSecurityEvents) {
                this.fireEventOnFailure = true;
                this.fireEventOnSuccess = true;
                this.successEvent = successEvent;
                this.failureEvent = failureEvent;
            } else {
                this.fireEventOnSuccess = !beanManager.resolveObserverMethods(successInstance, new Annotation[0]).isEmpty();
                this.fireEventOnFailure = !beanManager.resolveObserverMethods(failureInstance, new Annotation[0]).isEmpty();
                this.successEvent = this.fireEventOnSuccess ? successEvent : null;
                this.failureEvent = this.fireEventOnFailure ? failureEvent : null;
            }
        } else {
            this.fireEventOnSuccess = false;
            this.fireEventOnFailure = false;
            this.successEvent = null;
            this.failureEvent = null;
        }
    }

    public void fireSuccessEvent(S successInstance) {
        SecurityEventHelper.fire(this.successEvent, successInstance);
    }

    public void fireFailureEvent(F failureInstance) {
        SecurityEventHelper.fire(this.failureEvent, failureInstance);
    }

    public boolean fireEventOnSuccess() {
        return this.fireEventOnSuccess;
    }

    public boolean fireEventOnFailure() {
        return this.fireEventOnFailure;
    }

    public static <T extends SecurityEvent> void fire(Event<T> securityEvent, T event) {
        securityEvent.fire(event);
        securityEvent.fireAsync(event);
    }

    public static <T extends SecurityEvent> boolean isEventObserved(T event, BeanManager beanManager, boolean enabled) {
        if (enabled) {
            boolean fireAllSecurityEvents = !beanManager.resolveObserverMethods(new SecurityEvent(){

                @Override
                public SecurityIdentity getSecurityIdentity() {
                    return null;
                }

                @Override
                public Map<String, Object> getEventProperties() {
                    return Map.of();
                }
            }, new Annotation[0]).isEmpty();
            return fireAllSecurityEvents || !beanManager.resolveObserverMethods(event, new Annotation[0]).isEmpty();
        }
        return false;
    }

    public static <S extends SecurityEvent, F extends SecurityEvent> SecurityEventHelper<S, F> lazilyOf(Event<S> successEvent, Event<F> failureEvent, S successInstance, F failureInstance, BeanManager beanManager) {
        return new SecurityEventHelper<S, F>(successEvent, failureEvent, successInstance, failureInstance, beanManager, true){
            private volatile Boolean eventsDisabled = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean areEventsDisabled() {
                if (this.eventsDisabled == null) {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.eventsDisabled == null) {
                            this.eventsDisabled = ConfigProvider.getConfig().getValue("quarkus.security.events.enabled", Boolean.class) == false;
                        }
                    }
                }
                return this.eventsDisabled;
            }

            @Override
            public void fireSuccessEvent(S successInstance) {
                if (this.areEventsDisabled()) {
                    return;
                }
                super.fireSuccessEvent(successInstance);
            }

            @Override
            public void fireFailureEvent(F failureInstance) {
                if (this.areEventsDisabled()) {
                    return;
                }
                super.fireFailureEvent(failureInstance);
            }

            @Override
            public boolean fireEventOnSuccess() {
                if (this.areEventsDisabled()) {
                    return false;
                }
                return super.fireEventOnSuccess();
            }

            @Override
            public boolean fireEventOnFailure() {
                if (this.areEventsDisabled()) {
                    return false;
                }
                return super.fireEventOnFailure();
            }
        };
    }
}

