/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.context.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.context.runtime.QuarkusContextManagerProvider;
import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.SmallRyeManagedExecutor;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.impl.DefaultValues;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

@Recorder
public class SmallRyeContextPropagationRecorder {
    private static final ExecutorService NOPE_EXECUTOR_SERVICE = new ExecutorService(){

        @Override
        public void execute(Runnable command) {
            this.nope();
        }

        @Override
        public void shutdown() {
            this.nope();
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.nope();
            return null;
        }

        @Override
        public boolean isShutdown() {
            this.nope();
            return false;
        }

        @Override
        public boolean isTerminated() {
            this.nope();
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            this.nope();
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            this.nope();
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            this.nope();
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            this.nope();
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            this.nope();
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            this.nope();
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            this.nope();
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.nope();
            return null;
        }

        private void nope() {
            throw new RuntimeException("Trying to invoke ContextPropagation on a partially-configured ContextManager instance. You should wait until runtime init is done. You can do that by consuming the ContextPropagationBuildItem.");
        }
    };
    private static SmallRyeContextManager.Builder builder;

    public void configureStaticInit(List<ThreadContextProvider> discoveredProviders, List<ContextManagerExtension> discoveredExtensions) {
        if (ContextManagerProvider.INSTANCE.get() == null) {
            QuarkusContextManagerProvider contextManagerProvider = new QuarkusContextManagerProvider();
            ContextManagerProvider.register(contextManagerProvider);
        }
        builder = (SmallRyeContextManager.Builder)ContextManagerProvider.instance().getContextManagerBuilder();
        builder.withThreadContextProviders(discoveredProviders.toArray(new ThreadContextProvider[0]));
        builder.withContextManagerExtensions(discoveredExtensions.toArray(new ContextManagerExtension[0]));
        SmallRyeContextManager.Builder noContextBuilder = (SmallRyeContextManager.Builder)ContextManagerProvider.instance().getContextManagerBuilder();
        noContextBuilder.withThreadContextProviders(new ThreadContextProvider[0]);
        noContextBuilder.withContextManagerExtensions(new ContextManagerExtension[0]);
        noContextBuilder.withDefaultExecutorService(NOPE_EXECUTOR_SERVICE);
        noContextBuilder.withDefaultValues(DefaultValues.empty());
        ContextManagerProvider.instance().registerContextManager(noContextBuilder.build(), null);
    }

    public void configureRuntime(ExecutorService executorService, ShutdownContext shutdownContext) {
        final ContextManagerProvider contextManagerProvider = ContextManagerProvider.instance();
        builder.withDefaultExecutorService(executorService);
        final SmallRyeContextManager contextManager = builder.build();
        contextManagerProvider.registerContextManager(contextManager, Thread.currentThread().getContextClassLoader());
        shutdownContext.addLastShutdownTask(new Runnable(){

            @Override
            public void run() {
                contextManagerProvider.releaseContextManager(contextManager);
            }
        });
        builder = null;
    }

    public Supplier<Object> initializeManagedExecutor(final ExecutorService executorService) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                ThreadContext threadContext = Arc.container().instance(ThreadContext.class, new Annotation[0]).get();
                return new SmallRyeManagedExecutor(-1, -1, (SmallRyeThreadContext)threadContext, executorService, "no-ip"){

                    @Override
                    public void shutdown() {
                        throw new IllegalStateException("This executor is managed by the container and cannot be shut down.");
                    }

                    @Override
                    public List<Runnable> shutdownNow() {
                        throw new IllegalStateException("This executor is managed by the container and cannot be shut down.");
                    }
                };
            }
        };
    }

    public Supplier<Object> initializeConfiguredThreadContext(final String[] cleared, final String[] propagated, final String[] unchanged) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return ThreadContext.builder().propagated(propagated).cleared(cleared).unchanged(unchanged).build();
            }
        };
    }

    public Supplier<Object> initializeConfiguredManagedExecutor(final String[] cleared, final String[] propagated, final int maxAsync, final int maxQueued) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return ManagedExecutor.builder().propagated(propagated).cleared(cleared).maxAsync(maxAsync).maxQueued(maxQueued).build();
            }
        };
    }
}

