/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tls.CertificateUpdatedEvent;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class LetsEncryptRecorder {
    private TlsConfigurationRegistry registry;
    private Event<CertificateUpdatedEvent> event;
    private final AtomicReference<AcmeChallenge> acmeChallenge = new AtomicReference();
    private static final Logger LOGGER = Logger.getLogger(LetsEncryptRecorder.class);

    public void initialize(Supplier<TlsConfigurationRegistry> registry) {
        this.registry = registry.get();
        this.event = CDI.current().getBeanManager().getEvent().select(CertificateUpdatedEvent.class, new Annotation[0]);
    }

    public Handler<RoutingContext> challengeHandler() {
        return new Handler<RoutingContext>(){

            @Override
            public void handle(RoutingContext rc) {
                if (rc.request().method() != HttpMethod.GET) {
                    rc.response().setStatusCode(405).end();
                    return;
                }
                String token = rc.pathParam("token");
                if (token == null) {
                    rc.response().setStatusCode(404).end();
                    return;
                }
                AcmeChallenge challenge = LetsEncryptRecorder.this.acmeChallenge.get();
                if (challenge == null) {
                    LOGGER.debug("No Let's Encrypt challenge has been set");
                    rc.response().setStatusCode(404).end();
                    return;
                }
                if (challenge.matches(token)) {
                    rc.response().end(challenge.challenge());
                } else {
                    rc.response().setStatusCode(404).end();
                }
            }
        };
    }

    public void cleanupChallenge(RoutingContext rc) {
        if (this.acmeChallenge.getAndSet(null) == null) {
            rc.response().setStatusCode(404).end();
        } else {
            rc.response().setStatusCode(204).end();
        }
    }

    private void setupChallenge(RoutingContext rc) {
        AcmeChallenge challenge;
        if (rc.request().method() == HttpMethod.POST) {
            challenge = AcmeChallenge.fromJson(rc.body().asJsonObject());
        } else {
            String token = rc.request().getParam("challenge-resource");
            String challengeContent = rc.request().getParam("challenge-content");
            challenge = new AcmeChallenge(token, challengeContent);
        }
        if (!challenge.isValid()) {
            LOGGER.warn("Invalid Let's Encrypt challenge: " + String.valueOf(rc.body().asJsonObject()));
            rc.response().setStatusCode(400).end();
        } else if (this.acmeChallenge.compareAndSet(null, challenge)) {
            rc.response().setStatusCode(204).end();
        } else {
            LOGGER.warn("Let's Encrypt challenge already set");
            rc.response().setStatusCode(400).end();
        }
    }

    public void ready(RoutingContext rc) {
        TlsConfiguration config;
        String key = rc.request().getParam("key");
        if (key == null) {
            key = "<default>";
            config = this.registry.getDefault().orElse(null);
            if (config == null) {
                LOGGER.warn("Cannot handle Let's Encrypt flow - No default TLS configuration found. You must configure the quarkus.tls.* properties.");
                rc.response().setStatusCode(503).end();
                return;
            }
        } else {
            config = this.registry.get(key).orElse(null);
            if (config == null) {
                LOGGER.warn("Cannot handle Let's Encrypt flow - No " + key + " TLS configuration found. You must configure the quarkus.tls." + key + ".* properties.");
                rc.response().setStatusCode(503).end();
                return;
            }
        }
        if (config.getKeyStore() == null) {
            LOGGER.warn("Cannot handle Let's Encrypt flow - No keystore configured in quarkus.tls." + (key.equalsIgnoreCase("<default>") ? "" : key) + ".key-store");
            rc.response().setStatusCode(503).end();
            return;
        }
        AcmeChallenge challenge = this.acmeChallenge.get();
        if (challenge == null) {
            rc.response().setStatusCode(204).end();
        } else {
            rc.response().end(challenge.asJson());
        }
    }

    public Handler<RoutingContext> reload() {
        return new Handler<RoutingContext>(){

            @Override
            public void handle(final RoutingContext rc) {
                if (rc.request().method() != HttpMethod.POST) {
                    rc.response().setStatusCode(405).end();
                    return;
                }
                final String key = rc.request().getParam("key");
                final Optional<TlsConfiguration> configuration = key != null ? LetsEncryptRecorder.this.registry.get(key) : LetsEncryptRecorder.this.registry.getDefault();
                if (configuration.isEmpty()) {
                    LOGGER.warn("Cannot reload certificate, no configuration found for " + (String)(key == null ? "quarkus.tls" : "quarkus.tls." + key));
                    rc.response().setStatusCode(404).end();
                } else {
                    rc.vertx().executeBlocking(new Callable<Void>(){

                        @Override
                        public Void call() {
                            if (((TlsConfiguration)configuration.get()).reload()) {
                                LetsEncryptRecorder.this.event.fire(new CertificateUpdatedEvent(key == null ? "<default>" : key, (TlsConfiguration)configuration.get()));
                                rc.response().setStatusCode(204).end();
                            } else {
                                LOGGER.error("Failed to reload certificate");
                                rc.response().setStatusCode(500).end();
                            }
                            return null;
                        }
                    }, false);
                }
            }
        };
    }

    public Consumer<Route> setupCustomizer() {
        return new Consumer<Route>(){

            @Override
            public void accept(Route r) {
                r.method(HttpMethod.POST).method(HttpMethod.GET).method(HttpMethod.DELETE);
            }
        };
    }

    public Handler<RoutingContext> chalengeAdminHandler() {
        return new Handler<RoutingContext>(){

            @Override
            public void handle(RoutingContext rc) {
                if (rc.request().method() == HttpMethod.POST) {
                    LetsEncryptRecorder.this.setupChallenge(rc);
                } else if (rc.request().method() == HttpMethod.DELETE) {
                    LetsEncryptRecorder.this.cleanupChallenge(rc);
                } else if (rc.request().method() == HttpMethod.GET) {
                    if (rc.request().getParam("challenge-resource") != null) {
                        LetsEncryptRecorder.this.setupChallenge(rc);
                    } else {
                        LetsEncryptRecorder.this.ready(rc);
                    }
                } else {
                    rc.response().setStatusCode(405).end();
                }
            }
        };
    }

    private record AcmeChallenge(String token, String challenge) {
        boolean matches(String t) {
            return this.token.equals(t);
        }

        boolean isValid() {
            return this.token != null && this.challenge != null;
        }

        public String asJson() {
            return new JsonObject().put("challenge-resource", this.token).put("challenge-content", this.challenge).encode();
        }

        public static AcmeChallenge fromJson(JsonObject json) {
            return new AcmeChallenge(json.getString("challenge-resource"), json.getString("challenge-content"));
        }
    }
}

