/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.config;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.smallrye.certs.pem.parsers.EncryptedPKCS8Parser;
import io.smallrye.config.WithParentName;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.PemKeyCertOptions;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@ConfigGroup
public interface PemKeyCertConfig {
    @WithParentName
    public Map<String, KeyCertConfig> keyCerts();

    public Optional<List<String>> order();

    default public PemKeyCertOptions toOptions() {
        PemKeyCertOptions options = new PemKeyCertOptions();
        if (this.keyCerts().isEmpty()) {
            throw new IllegalArgumentException("You must specify the key files and certificate files");
        }
        ArrayList<KeyCertConfig> orderedListOfPair = new ArrayList<KeyCertConfig>();
        if (this.order().isPresent()) {
            if (this.order().get().size() != this.keyCerts().size()) {
                throw new IllegalArgumentException("The size of the `order` list (" + this.order().get().size() + ") must match the size of the `keyCerts` map (" + this.keyCerts().size() + ")");
            }
            for (String name : this.order().get()) {
                KeyCertConfig keyCert = this.keyCerts().get(name);
                if (keyCert == null) {
                    throw new IllegalArgumentException("The key/cert pair with the name '" + name + "' is not found in the `order` list: " + String.valueOf(this.order().get()));
                }
                orderedListOfPair.add(keyCert);
            }
        } else {
            orderedListOfPair.addAll(new TreeMap<String, KeyCertConfig>(this.keyCerts()).values());
        }
        for (KeyCertConfig config : orderedListOfPair) {
            options.addCertValue(Buffer.buffer(TlsConfigUtils.read(config.cert())));
            if (config.password().isPresent()) {
                byte[] content = TlsConfigUtils.read(config.key());
                String contentAsString = new String(content, StandardCharsets.UTF_8);
                Buffer decrypted = new EncryptedPKCS8Parser().decryptKey(contentAsString, config.password().get());
                if (decrypted == null) {
                    throw new IllegalArgumentException("Unable to decrypt the key file: " + String.valueOf(config.key()));
                }
                options.addKeyValue(decrypted);
                continue;
            }
            options.addKeyValue(Buffer.buffer(TlsConfigUtils.read(config.key())));
        }
        return options;
    }

    public static interface KeyCertConfig {
        public Path key();

        public Path cert();

        public Optional<String> password();
    }
}

