/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.keystores;

import io.quarkus.tls.runtime.KeyStoreAndKeyCertOptions;
import io.quarkus.tls.runtime.TrustStoreAndTrustOptions;
import io.quarkus.tls.runtime.config.KeyStoreConfig;
import io.quarkus.tls.runtime.config.PemCertsConfig;
import io.quarkus.tls.runtime.config.PemKeyCertConfig;
import io.quarkus.tls.runtime.config.TrustStoreConfig;
import io.quarkus.tls.runtime.keystores.ExpiryTrustOptions;
import io.vertx.core.Vertx;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import java.io.UncheckedIOException;
import java.security.KeyStore;

public class PemKeyStores {
    private PemKeyStores() {
    }

    public static KeyStoreAndKeyCertOptions verifyPEMKeyStore(KeyStoreConfig ksc, Vertx vertx, String name) {
        PemKeyCertConfig config = ksc.pem().orElseThrow();
        if (config.keyCerts().isEmpty()) {
            throw new IllegalStateException("No key/certificate pair configured for certificate '" + name + "'");
        }
        try {
            PemKeyCertOptions options = config.toOptions();
            return new KeyStoreAndKeyCertOptions(options.loadKeyStore(vertx), options);
        }
        catch (UncheckedIOException e) {
            throw new IllegalStateException("Invalid key/certificate pair configuration for certificate '" + name + "' - cannot read the key/certificate files", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid key/certificate pair configuration for certificate '" + name + "'", e);
        }
    }

    public static TrustStoreAndTrustOptions verifyPEMTrustStoreStore(TrustStoreConfig tsc, Vertx vertx, String name) {
        PemCertsConfig config = tsc.pem().orElseThrow();
        if (config.certs().isEmpty() || config.certs().get().isEmpty()) {
            throw new IllegalStateException("No PEM certificates configured for the trust store of '" + name + "'");
        }
        try {
            PemTrustOptions options = config.toOptions();
            KeyStore ks = options.loadKeyStore(vertx);
            if (tsc.certificateExpirationPolicy() == TrustStoreConfig.CertificateExpiryPolicy.IGNORE) {
                return new TrustStoreAndTrustOptions(ks, options);
            }
            ExpiryTrustOptions wrapped = new ExpiryTrustOptions(options, tsc.certificateExpirationPolicy());
            return new TrustStoreAndTrustOptions(ks, wrapped);
        }
        catch (UncheckedIOException e) {
            throw new IllegalStateException("Invalid PEM trusted certificates configuration for certificate '" + name + "' - cannot read the PEM certificate files", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid PEM trusted certificates configuration for certificate '" + name + "'", e);
        }
    }
}

