/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.quarkus.runtime.util.ForwardingExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class DevModeExecutorService
extends ForwardingExecutorService {
    private static final Logger LOG = Logger.getLogger(DevModeExecutorService.class);
    private final Supplier<ExecutorService> initializer;
    private volatile ExecutorService executor;

    DevModeExecutorService(Supplier<ExecutorService> initializer) {
        this.initializer = initializer;
        this.executor = initializer.get();
    }

    @Override
    protected ExecutorService delegate() {
        return this.executor;
    }

    void reinit() {
        ExecutorService oldExecutor = this.executor;
        if (oldExecutor != null) {
            oldExecutor.shutdownNow();
        }
        this.executor = this.initializer.get();
        LOG.debug("Dev mode executor re-initialized");
    }
}

