/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import java.util.function.Consumer;
import java.util.function.Function;

public class BasicRoute
implements Function<Router, Route> {
    private String name;
    private String path;
    private Integer order;
    private Consumer<Route> customizer;

    public BasicRoute(String path) {
        this(null, path);
    }

    public BasicRoute(String path, Integer order) {
        this(null, path, order);
    }

    public BasicRoute(String path, Integer order, Consumer<Route> customizer) {
        this(null, path, order, customizer);
    }

    public BasicRoute(String name, String path) {
        this(name, path, null);
    }

    public BasicRoute(String name, String path, Integer order) {
        this.name = name;
        this.path = path;
        this.order = order;
    }

    public BasicRoute(String name, String path, Integer order, Consumer<Route> customizer) {
        this.name = name;
        this.path = path;
        this.order = order;
        this.customizer = customizer;
    }

    public BasicRoute() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Consumer<Route> getCustomizer() {
        return this.customizer;
    }

    public BasicRoute setCustomizer(Consumer<Route> customizer) {
        this.customizer = customizer;
        return this;
    }

    @Override
    public Route apply(Router router) {
        Route route = router.route(this.path);
        if (this.name != null) {
            route.setName(this.name);
        }
        if (this.order != null) {
            route.order(this.order);
        }
        if (this.customizer != null) {
            this.customizer.accept(route);
        }
        return route;
    }
}

