/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.vertx.http.runtime.filters.AbstractResponseWrapper;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.http.impl.HttpServerRequestWrapper;

public class ResumingRequestWrapper
extends HttpServerRequestWrapper {
    private final HttpServerResponse httpServerResponse;
    private boolean userSetState;

    public ResumingRequestWrapper(HttpServerRequest request, boolean mustResumeRequest) {
        super((HttpServerRequestInternal)request);
        if (mustResumeRequest) {
            HttpServerResponse response = this.delegate.response();
            response.endHandler(new Handler<Void>(){

                @Override
                public void handle(Void unused) {
                    if (!ResumingRequestWrapper.this.delegate.isEnded()) {
                        ResumingRequestWrapper.this.delegate.resume();
                    }
                }
            });
            this.httpServerResponse = new AbstractResponseWrapper(response){

                @Override
                public HttpServerResponse endHandler(final Handler<Void> handler) {
                    return super.endHandler(new Handler<Void>(){

                        @Override
                        public void handle(Void unused) {
                            handler.handle(null);
                            if (!ResumingRequestWrapper.this.delegate.isEnded()) {
                                ResumingRequestWrapper.this.delegate.resume();
                            }
                        }
                    });
                }
            };
        } else {
            this.httpServerResponse = null;
        }
    }

    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        this.delegate.handler((Handler)handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    @Override
    public HttpServerRequest pause() {
        this.userSetState = true;
        this.delegate.pause();
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        this.userSetState = true;
        this.delegate.resume();
        return this;
    }

    @Override
    public HttpServerRequest fetch(long amount) {
        this.userSetState = true;
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        this.delegate.endHandler((Handler)handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    @Override
    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        this.delegate.bodyHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        this.delegate.uploadHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    @Override
    public HttpServerResponse response() {
        if (this.httpServerResponse != null) {
            return this.httpServerResponse;
        }
        return super.response();
    }
}

