/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.Map;

public class VertxConfigBuilder
implements ConfigBuilder {
    private static final String QUARKUS_HTTP_HOST = "quarkus.http.host";
    private static final String QUARKUS_MANAGEMENT_HOST = "quarkus.management.host";
    private static final String LOCALHOST = "localhost";
    private static final String ALL_INTERFACES = "0.0.0.0";

    @Override
    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        VertxConfigBuilder.defineHttpInterface(builder, QUARKUS_HTTP_HOST);
        VertxConfigBuilder.defineHttpInterface(builder, QUARKUS_MANAGEMENT_HOST);
        return builder;
    }

    private static void defineHttpInterface(SmallRyeConfigBuilder builder, String configurationProperty) {
        if (builder.getDefaultValues().get(configurationProperty) != null) {
            return;
        }
        if (LaunchMode.isRemoteDev()) {
            builder.withDefaultValue(configurationProperty, ALL_INTERFACES);
        } else if (LaunchMode.current().isDevOrTest()) {
            if (!VertxConfigBuilder.isWSL()) {
                builder.withDefaultValue(configurationProperty, LOCALHOST);
            } else {
                builder.withDefaultValue(configurationProperty, ALL_INTERFACES);
            }
        } else {
            builder.withDefaultValue(configurationProperty, ALL_INTERFACES);
        }
    }

    private static boolean isWSL() {
        Map<String, String> sysEnv = System.getenv();
        return sysEnv.containsKey("IS_WSL") || sysEnv.containsKey("WSL_DISTRO_NAME");
    }
}

