/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableObserverMethod;
import io.quarkus.arc.RemovedBean;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.devmode.Json;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Recorder
public class ArcDevRecorder {
    public Handler<RoutingContext> createSummaryHandler(final Map<String, String> configProperties, final String rootPath, final int removedInterceptorsDecorators) {
        return new Handler<RoutingContext>(){

            @Override
            public void handle(RoutingContext ctx) {
                ctx.response().putHeader("Content-Type", "application/json");
                ArcContainerImpl container = ArcContainerImpl.instance();
                Json.JsonObjectBuilder summary = Json.object();
                summary.put("beans", container.getBeans().size());
                summary.put("removedBeans", container.getRemovedBeans().size() + removedInterceptorsDecorators);
                summary.put("observers", container.getObservers().size());
                summary.put("interceptors", container.getInterceptors().size());
                Json.JsonArrayBuilder scopes = Json.array();
                container.getScopes().stream().map(Class::getName).forEach(scopes::add);
                summary.put("scopes", scopes);
                Json.JsonObjectBuilder config = Json.object();
                for (Map.Entry entry : configProperties.entrySet()) {
                    if (((String)entry.getValue()).equals("true") || ((String)entry.getValue()).equals("false")) {
                        config.put((String)entry.getKey(), Boolean.parseBoolean((String)entry.getValue()));
                        continue;
                    }
                    config.put((String)entry.getKey(), (String)entry.getValue());
                }
                summary.put("config", config);
                Json.JsonObjectBuilder links = Json.object();
                links.put("beans", rootPath + "arc/beans");
                links.put("observers", rootPath + "arc/observers");
                links.put("removed-beans", rootPath + "arc/removed-beans");
                summary.put("links", links);
                ctx.response().end(summary.build());
            }
        };
    }

    public Handler<RoutingContext> createBeansHandler(final String beanDependenciesGlobalKey) {
        return new Handler<RoutingContext>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void handle(RoutingContext ctx) {
                ctx.response().putHeader("Content-Type", "application/json");
                ArcContainerImpl container = ArcContainerImpl.instance();
                ArrayList beans = new ArrayList();
                beans.addAll(container.getBeans());
                beans.addAll(container.getInterceptors());
                beans.addAll(container.getDecorators());
                String kindParam = ctx.request().getParam("kind");
                InjectableBean.Kind kind = kindParam != null ? InjectableBean.Kind.from(kindParam.toUpperCase()) : null;
                String scopeEndsWith = ctx.request().getParam("scope");
                String beanClassStartsWith = ctx.request().getParam("beanClass");
                Iterator it = beans.iterator();
                while (it.hasNext()) {
                    InjectableBean injectableBean = (InjectableBean)it.next();
                    if (kind != null && !kind.equals((Object)injectableBean.getKind())) {
                        it.remove();
                    }
                    if (scopeEndsWith != null && !injectableBean.getScope().getName().endsWith(scopeEndsWith)) {
                        it.remove();
                    }
                    if (beanClassStartsWith == null || injectableBean.getBeanClass().getName().startsWith(beanClassStartsWith)) continue;
                    it.remove();
                }
                Map beanDependenciesMap = (Map)DevConsoleManager.getGlobal(beanDependenciesGlobalKey);
                Json.JsonArrayBuilder array = Json.array();
                for (InjectableBean injectableBean : beans) {
                    void var15_15;
                    Json.JsonObjectBuilder bean = Json.object(true);
                    bean.put("id", injectableBean.getIdentifier());
                    bean.put("kind", injectableBean.getKind().toString());
                    bean.put("generatedClass", injectableBean.getClass().getName());
                    bean.put("beanClass", injectableBean.getBeanClass().getName());
                    Json.JsonArrayBuilder types = Json.array();
                    for (Type type : injectableBean.getTypes()) {
                        types.add(type.getTypeName());
                    }
                    bean.put("types", types);
                    Json.JsonArrayBuilder qualifiers = Json.array();
                    for (Annotation qualifier : injectableBean.getQualifiers()) {
                        if (qualifier.annotationType().equals(Any.class) || qualifier.annotationType().equals(Default.class)) {
                            qualifiers.add("@" + qualifier.annotationType().getSimpleName());
                            continue;
                        }
                        qualifiers.add(qualifier.toString());
                    }
                    bean.put("qualifiers", qualifiers);
                    bean.put("scope", injectableBean.getScope().getName());
                    if (injectableBean.getDeclaringBean() != null) {
                        bean.put("declaringBean", injectableBean.getDeclaringBean().getIdentifier());
                    }
                    if (injectableBean.getName() != null) {
                        bean.put("name", injectableBean.getName());
                    }
                    if (injectableBean.isAlternative()) {
                        bean.put("alternativePriority", injectableBean.getAlternativePriority());
                    }
                    if (injectableBean.isDefaultBean()) {
                        bean.put("isDefault", true);
                    }
                    List<String> list = Collections.emptyList();
                    if (beanDependenciesMap != null) {
                        List list2 = beanDependenciesMap.getOrDefault(injectableBean.getIdentifier(), Collections.emptyList());
                    }
                    Json.JsonArrayBuilder dependencies = Json.array();
                    for (String beanId : var15_15) {
                        dependencies.add(beanId);
                    }
                    bean.put("dependencies", dependencies);
                    array.add(bean);
                }
                ctx.response().end(array.build());
            }
        };
    }

    public Handler<RoutingContext> createObserversHandler() {
        return new Handler<RoutingContext>(){

            @Override
            public void handle(RoutingContext ctx) {
                ctx.response().putHeader("Content-Type", "application/json");
                ArcContainerImpl container = ArcContainerImpl.instance();
                List<InjectableObserverMethod<?>> observers = container.getObservers();
                Json.JsonArrayBuilder array = Json.array();
                for (InjectableObserverMethod<?> injectableObserver : observers) {
                    Json.JsonObjectBuilder observer = Json.object();
                    observer.put("generatedClass", injectableObserver.getClass().getName());
                    observer.put("observedType", injectableObserver.getObservedType().getTypeName());
                    if (!injectableObserver.getObservedQualifiers().isEmpty()) {
                        Json.JsonArrayBuilder qualifiers = Json.array();
                        for (Annotation qualifier : injectableObserver.getObservedQualifiers()) {
                            qualifiers.add(qualifier.toString());
                        }
                        observer.put("qualifiers", qualifiers);
                    }
                    observer.put("priority", injectableObserver.getPriority());
                    observer.put("reception", injectableObserver.getReception().toString());
                    observer.put("transactionPhase", injectableObserver.getTransactionPhase().toString());
                    observer.put("async", injectableObserver.isAsync());
                    if (injectableObserver.getDeclaringBeanIdentifier() != null) {
                        observer.put("declaringBean", injectableObserver.getDeclaringBeanIdentifier());
                    }
                    array.add(observer);
                }
                ctx.response().end(array.build());
            }
        };
    }

    public Handler<RoutingContext> createRemovedBeansHandler(final List<String[]> removedInterceptorsDecorators) {
        return new Handler<RoutingContext>(){

            @Override
            public void handle(RoutingContext ctx) {
                Json.JsonObjectBuilder bean;
                ArcContainerImpl container = ArcContainerImpl.instance();
                ctx.response().putHeader("Content-Type", "application/json");
                Json.JsonArrayBuilder removed = Json.array();
                for (RemovedBean removedBean : container.getRemovedBeans()) {
                    bean = Json.object();
                    bean.put("kind", removedBean.getKind().toString());
                    bean.put("description", removedBean.getDescription());
                    Json.JsonArrayBuilder types = Json.array();
                    for (Type beanType : removedBean.getTypes()) {
                        types.add(beanType instanceof Class ? ((Class)beanType).getName() : beanType.toString());
                    }
                    types.add(Object.class.getName());
                    bean.put("types", types);
                    Json.JsonArrayBuilder qualifiers = Json.array();
                    for (Annotation qualifier : removedBean.getQualifiers()) {
                        if (qualifier.annotationType().equals(Any.class) || qualifier.annotationType().equals(Default.class)) {
                            qualifiers.add("@" + qualifier.annotationType().getSimpleName());
                            continue;
                        }
                        qualifiers.add(qualifier.toString());
                    }
                    bean.put("qualifiers", qualifiers);
                    removed.add(bean);
                }
                for (String[] interceptorDecorator : removedInterceptorsDecorators) {
                    bean = Json.object();
                    bean.put("kind", interceptorDecorator[0]);
                    bean.put("description", interceptorDecorator[1]);
                    removed.add(bean);
                }
                ctx.response().end(removed.build());
            }
        };
    }
}

