/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.devui.runtime.config.ConfigDescription;
import io.quarkus.vertx.http.runtime.devmode.ConfigSourceName;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Expressions;
import io.smallrye.config.SmallRyeConfig;
import io.vertx.core.impl.ConcurrentHashSet;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConfigDescriptionsManager
implements Supplier<ConfigDescriptionsManager> {
    private final List<ConfigDescription> configDescriptions;
    private final Set<String> devServicesProperties;
    private ClassLoader currentCl;
    private static final String QUOTED_DOT = "\".\"";
    private static final String QUOTED_DOT_KEY = "$$QUOTED_DOT$$";
    volatile Map<ConfigSourceName, List<ConfigDescription>> values;
    private static Set<String> addedConfigKeys = new ConcurrentHashSet<String>();

    public ConfigDescriptionsManager() {
        this(List.of());
    }

    public ConfigDescriptionsManager(List<ConfigDescription> configDescriptions) {
        this(configDescriptions, Set.of());
    }

    public ConfigDescriptionsManager(List<ConfigDescription> configDescriptions, Set<String> devServicesProperties) {
        this.configDescriptions = Collections.unmodifiableList(new ArrayList<ConfigDescription>(configDescriptions));
        this.devServicesProperties = devServicesProperties;
        this.currentCl = Thread.currentThread().getContextClassLoader();
    }

    public Map<ConfigSourceName, List<ConfigDescription>> values() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.currentCl);
            if (this.values == null) {
                this.values = this.calculate();
            }
            Map<ConfigSourceName, List<ConfigDescription>> map = this.values;
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void addNamedConfigGroup(String name) {
        addedConfigKeys.add(name + ".fake");
        this.values = this.calculate();
    }

    /*
     * WARNING - void declaration
     */
    public Map<ConfigSourceName, List<ConfigDescription>> calculate() {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>(this.configDescriptions);
        TreeMap<ConfigSourceName, List<ConfigDescription>> ordered = new TreeMap<ConfigSourceName, List<ConfigDescription>>();
        ArrayList<String> properties = new ArrayList<String>();
        SmallRyeConfig current = (SmallRyeConfig)ConfigProvider.getConfig();
        HashMap<List, Set> allPropertySegments = new HashMap<List, Set>();
        HashSet<String> propertyNames = new HashSet<String>(addedConfigKeys);
        current.getPropertyNames().forEach(propertyNames::add);
        for (String propertyName : propertyNames) {
            propertyName = propertyName.replace(QUOTED_DOT, QUOTED_DOT_KEY);
            String[] parts = propertyName.split("\\.");
            ArrayList<String> accumulate = new ArrayList<String>();
            for (int i = 0; i < parts.length - 1 && !parts[i].isEmpty(); ++i) {
                if (parts[i].contains(QUOTED_DOT_KEY)) {
                    parts[i] = parts[i].replaceAll(QUOTED_DOT_KEY, QUOTED_DOT);
                }
                accumulate.add(parts[i]);
                Set potentialSegmentSet = allPropertySegments.computeIfAbsent(List.copyOf(accumulate), k -> new HashSet());
                if (this.isQuoted(parts[i + 1])) {
                    potentialSegmentSet.add(parts[i + 1]);
                    potentialSegmentSet.remove(parts[i + 1].substring(1, parts[i + 1].length() - 1));
                    continue;
                }
                if (potentialSegmentSet.contains(this.ensureQuoted(parts[i + 1]))) continue;
                potentialSegmentSet.add(parts[i + 1]);
            }
        }
        HashMap wildcardsToAdd = new HashMap();
        HashMap<String, Holder> foundItems = new HashMap<String, Holder>();
        HashSet<String> bannedExpansionCombos = new HashSet<String>();
        for (ConfigDescription configDescription : configDescriptions) {
            void var16_30;
            if (!configDescription.getName().contains("{*}")) {
                bannedExpansionCombos.add(configDescription.getName());
                for (int i = 0; i < configDescription.getName().length(); ++i) {
                    if (configDescription.getName().charAt(i) != '.') continue;
                    bannedExpansionCombos.add(configDescription.getName().substring(0, i));
                }
                properties.add(configDescription.getName());
                configDescription.setConfigValue(current.getConfigValue(configDescription.getName()));
                String configSourceName = configDescription.getConfigValue().getConfigSourceName();
                int configSourceOrdinal = configDescription.getConfigValue().getConfigSourceOrdinal();
                ordered.putIfAbsent(new ConfigSourceName(configSourceName, configSourceOrdinal), new ArrayList());
                ((List)ordered.get(new ConfigSourceName(configSourceName, configSourceOrdinal))).add(configDescription);
                continue;
            }
            if (configDescription.getName().startsWith("quarkus.log.filter")) continue;
            ArrayList componentParts = new ArrayList();
            ArrayList<String> accumulator = new ArrayList<String>();
            String[] stringArray = configDescription.getName().split("\\.");
            int n = stringArray.length;
            boolean bl = false;
            while (var16_30 < n) {
                String i = stringArray[var16_30];
                if (i.equals("{*}")) {
                    componentParts.add(accumulator);
                    accumulator = new ArrayList();
                } else {
                    accumulator.add(i);
                }
                ++var16_30;
            }
            HashMap building = new HashMap();
            building.put(List.of(), new HashSet());
            for (List list : componentParts) {
                HashMap newBuilding = new HashMap();
                for (Map.Entry entry : building.entrySet()) {
                    List attempt = (List)entry.getKey();
                    ArrayList newBase = new ArrayList(attempt);
                    newBase.addAll(list);
                    wildcardsToAdd.put(newBase, (Set)entry.getValue());
                    Set potential = (Set)allPropertySegments.get(newBase);
                    if (potential == null) continue;
                    bannedExpansionCombos.add(String.join((CharSequence)".", newBase).replace("\"", ""));
                    for (String definedName : potential) {
                        ArrayList<String> toAdd = new ArrayList<String>(newBase);
                        toAdd.add(definedName);
                        HashSet<CallSite> expansionKeys = new HashSet<CallSite>((Collection)entry.getValue());
                        expansionKeys.add((CallSite)((Object)(String.join((CharSequence)".", newBase) + "." + definedName)));
                        newBuilding.put(toAdd, expansionKeys);
                    }
                }
                building = newBuilding;
            }
            for (Map.Entry entry : building.entrySet()) {
                List segments = (List)entry.getKey();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < segments.size(); ++i) {
                    if (i > 0) {
                        sb.append(".");
                    }
                    sb.append((String)segments.get(i));
                }
                for (String s : accumulator) {
                    sb.append(".").append(s);
                }
                String expandedName = sb.toString();
                foundItems.put(expandedName, new Holder((Set)entry.getValue(), configDescription));
            }
        }
        for (Map.Entry entry : foundItems.entrySet()) {
            boolean ok = true;
            for (String key : ((Holder)entry.getValue()).expansionKeys) {
                if (!bannedExpansionCombos.contains(key)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            String expandedName = (String)entry.getKey();
            ConfigDescription item = ((Holder)entry.getValue()).configDescription;
            ConfigDescription newDesc = new ConfigDescription(expandedName, item.getDescription(), item.getDefaultValue(), this.devServicesProperties.contains(expandedName), item.getTypeName(), item.getAllowedValues(), item.getConfigPhase());
            properties.add(newDesc.getName());
            newDesc.setConfigValue(current.getConfigValue(newDesc.getName()));
            String string = newDesc.getConfigValue().getConfigSourceName();
            int configSourceOrdinal = newDesc.getConfigValue().getConfigSourceOrdinal();
            ordered.putIfAbsent(new ConfigSourceName(string, configSourceOrdinal), new ArrayList());
            ((List)ordered.get(new ConfigSourceName(string, configSourceOrdinal))).add(newDesc);
        }
        for (Map.Entry entry : wildcardsToAdd.entrySet()) {
            boolean ok = true;
            for (String key : (Set)entry.getValue()) {
                if (!bannedExpansionCombos.contains(key)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            List segments = (List)entry.getKey();
            StringBuilder sb = new StringBuilder();
            for (String string : segments) {
                sb.append(string);
                sb.append(".");
            }
            String expandedName = sb.toString();
            ConfigDescription configDescription = new ConfigDescription(expandedName, true);
            properties.add(configDescription.getName());
            configDescription.setConfigValue(current.getConfigValue(configDescription.getName()));
            String configSourceName = configDescription.getConfigValue().getConfigSourceName();
            int configSourceOrdinal = configDescription.getConfigValue().getConfigSourceOrdinal();
            ordered.putIfAbsent(new ConfigSourceName(configSourceName, configSourceOrdinal), new ArrayList());
            ((List)ordered.get(new ConfigSourceName(configSourceName, configSourceOrdinal))).add(configDescription);
        }
        for (ConfigSource configSource : current.getConfigSources()) {
            if (!configSource.getName().equals("PropertiesConfigSource[source=Build system]")) continue;
            properties.addAll(configSource.getPropertyNames());
        }
        Expressions.withoutExpansion(() -> {
            for (String propertyName : current.getPropertyNames()) {
                if (properties.contains(propertyName)) continue;
                ConfigDescription item = new ConfigDescription(propertyName, null, null, current.getConfigValue(propertyName));
                ConfigValue configValue = current.getConfigValue(propertyName);
                ConfigSourceName csn = new ConfigSourceName(configValue.getConfigSourceName(), configValue.getConfigSourceOrdinal());
                ordered.putIfAbsent(csn, new ArrayList());
                ((List)ordered.get(csn)).add(item);
                configDescriptions.add(item);
            }
        });
        for (List list : ordered.values()) {
            Collections.sort(list);
        }
        return ordered;
    }

    private String ensureQuoted(String part) {
        if (this.isQuoted(part)) {
            return part;
        }
        return "\"" + part + "\"";
    }

    private boolean isQuoted(String part) {
        return part.length() >= 2 && part.charAt(0) == '\"' && part.charAt(part.length() - 1) == '\"';
    }

    @Override
    public ConfigDescriptionsManager get() {
        this.currentCl = Thread.currentThread().getContextClassLoader();
        return this;
    }

    static class Holder {
        final Set<String> expansionKeys;
        final ConfigDescription configDescription;

        private Holder(Set<String> expansionKeys, ConfigDescription configDescription) {
            this.expansionKeys = expansionKeys;
            this.configDescription = configDescription;
        }
    }
}

