/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.vertx.http.runtime.devmode.ResourceNotFoundData;
import io.vertx.core.Handler;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Locale;

public class ResourceNotFoundHandler
implements Handler<RoutingContext> {
    private final ResourceNotFoundData resourceNotFoundData = (ResourceNotFoundData)CDI.current().select(ResourceNotFoundData.class, new Annotation[0]).get();

    @Override
    public void handle(RoutingContext routingContext) {
        String header = routingContext.request().getHeader("Accept");
        if (header != null && header.startsWith("application/json")) {
            this.handleJson(routingContext);
        } else if (header != null && header.startsWith("text/html")) {
            this.handleHTML(routingContext);
        } else {
            String userAgent = routingContext.request().getHeader("User-Agent");
            if (userAgent != null && (userAgent.toLowerCase(Locale.ROOT).startsWith("wget/") || userAgent.toLowerCase(Locale.ROOT).startsWith("curl/"))) {
                this.handleText(routingContext);
            } else {
                this.handleHTML(routingContext);
            }
        }
    }

    private void handleJson(RoutingContext routingContext) {
        routingContext.response().setStatusCode(404).putHeader("content-type", "application/json; charset=utf-8").end(Json.encodePrettily(this.resourceNotFoundData.getJsonContent()));
    }

    private void handleText(RoutingContext routingContext) {
        routingContext.response().setStatusCode(404).putHeader("content-type", "text/plain; charset=utf-8").end(this.resourceNotFoundData.getTextContent());
    }

    private void handleHTML(RoutingContext routingContext) {
        routingContext.response().setStatusCode(404).putHeader("content-type", "text/html; charset=utf-8").end(this.resourceNotFoundData.getHTMLContent());
    }
}

