/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.management;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceConfiguration;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.ManagementInterfaceHttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.ManagementPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesMapping;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;

@Recorder
public class ManagementInterfaceSecurityRecorder {
    public RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> managementAuthenticationHandler(boolean proactiveAuthentication) {
        return new RuntimeValue<HttpSecurityRecorder.AuthenticationHandler>(new HttpSecurityRecorder.AuthenticationHandler(proactiveAuthentication));
    }

    public Handler<RoutingContext> getAuthenticationHandler(RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> handlerRuntimeValue) {
        return handlerRuntimeValue.getValue();
    }

    public void initializeAuthenticationHandler(RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> handler, ManagementInterfaceConfiguration runTimeConfig) {
        handler.getValue().init(ManagementPathMatchingHttpSecurityPolicy.class, RolesMapping.of(runTimeConfig.auth.rolesMapping));
    }

    public Handler<RoutingContext> permissionCheckHandler() {
        return new Handler<RoutingContext>(){
            private volatile ManagementInterfaceHttpAuthorizer authorizer;

            @Override
            public void handle(RoutingContext event) {
                if (this.authorizer == null) {
                    this.authorizer = (ManagementInterfaceHttpAuthorizer)CDI.current().select(ManagementInterfaceHttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public Supplier<?> setupBasicAuth() {
        return new Supplier<BasicAuthenticationMechanism>(){

            @Override
            public BasicAuthenticationMechanism get() {
                return new BasicAuthenticationMechanism(null, false);
            }
        };
    }
}

