/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.options;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.runtime.FilterConfig;
import io.quarkus.vertx.http.runtime.ForwardedProxyHandler;
import io.quarkus.vertx.http.runtime.ForwardedServerRequestWrapper;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.quarkus.vertx.http.runtime.HeaderConfig;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.ResumingRequestWrapper;
import io.quarkus.vertx.http.runtime.ServerLimitsConfig;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class HttpServerCommonHandlers {
    public static void enforceMaxBodySize(ServerLimitsConfig limits, Router httpRouteRouter) {
        if (limits.maxBodySize.isPresent()) {
            final long limit = limits.maxBodySize.get().asLongValue();
            final Long limitObj = limit;
            httpRouteRouter.route().order(-2).handler(new Handler<RoutingContext>(){

                @Override
                public void handle(final RoutingContext event) {
                    String lengthString = event.request().headers().get(HttpHeaderNames.CONTENT_LENGTH);
                    if (lengthString != null) {
                        long length = Long.parseLong(lengthString);
                        if (length > limit) {
                            event.response().headers().add((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)"close");
                            event.response().setStatusCode(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.code());
                            event.response().endHandler(new Handler<Void>(){

                                @Override
                                public void handle(Void e) {
                                    event.request().connection().close();
                                }
                            });
                            event.response().end();
                            return;
                        }
                    } else {
                        event.put("io.quarkus.max-request-size", limitObj);
                    }
                    event.next();
                }
            });
        }
    }

    public static Handler<HttpServerRequest> enforceDuplicatedContext(final Handler<HttpServerRequest> delegate, final boolean mustResumeRequest) {
        return new Handler<HttpServerRequest>(){

            @Override
            public void handle(final HttpServerRequest event) {
                if (!VertxContext.isOnDuplicatedContext()) {
                    Context context = VertxContext.createNewDuplicatedContext();
                    context.runOnContext(new Handler<Void>(){

                        @Override
                        public void handle(Void x) {
                            VertxContextSafetyToggle.setCurrentContextSafe(true);
                            delegate.handle(new ResumingRequestWrapper(event, mustResumeRequest));
                        }
                    });
                } else {
                    VertxContextSafetyToggle.setCurrentContextSafe(true);
                    delegate.handle(new ResumingRequestWrapper(event, mustResumeRequest));
                }
            }
        };
    }

    public static Handler<HttpServerRequest> applyProxy(ProxyConfig proxyConfig, final Handler<HttpServerRequest> root, Supplier<Vertx> vertx) {
        if (proxyConfig.proxyAddressForwarding) {
            final ForwardingProxyOptions forwardingProxyOptions = ForwardingProxyOptions.from(proxyConfig);
            TrustedProxyCheck.TrustedProxyCheckBuilder proxyCheckBuilder = forwardingProxyOptions.trustedProxyCheckBuilder;
            if (proxyCheckBuilder == null) {
                final TrustedProxyCheck allowAllProxyCheck = TrustedProxyCheck.allowAll();
                return new Handler<HttpServerRequest>(){

                    @Override
                    public void handle(HttpServerRequest event) {
                        root.handle(new ForwardedServerRequestWrapper(event, forwardingProxyOptions, allowAllProxyCheck));
                    }
                };
            }
            return new ForwardedProxyHandler(proxyCheckBuilder, vertx, root, forwardingProxyOptions);
        }
        return root;
    }

    public static void applyFilters(Map<String, FilterConfig> filtersInConfig, Router httpRouteRouter) {
        if (!filtersInConfig.isEmpty()) {
            for (Map.Entry<String, FilterConfig> entry : filtersInConfig.entrySet()) {
                FilterConfig filterConfig = entry.getValue();
                String matches = filterConfig.matches;
                int order = filterConfig.order.orElse(Integer.MIN_VALUE);
                Optional<List<String>> methods = filterConfig.methods;
                final Map<String, String> headers = filterConfig.header;
                if (methods.isEmpty()) {
                    httpRouteRouter.routeWithRegex(matches).order(order).handler(new Handler<RoutingContext>(){

                        @Override
                        public void handle(RoutingContext event) {
                            HttpServerCommonHandlers.addFilterHeaders(event, headers);
                            event.next();
                        }
                    });
                    continue;
                }
                for (String method : methods.get()) {
                    httpRouteRouter.routeWithRegex(HttpMethod.valueOf(method.toUpperCase(Locale.ROOT)), matches).order(order).handler(new Handler<RoutingContext>(){

                        @Override
                        public void handle(RoutingContext event) {
                            HttpServerCommonHandlers.addFilterHeaders(event, headers);
                            event.next();
                        }
                    });
                }
            }
        }
    }

    private static void addFilterHeaders(RoutingContext event, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            MultiMap responseHeaders = event.response().headers();
            List<String> oldValues = responseHeaders.getAll(key);
            if (oldValues.isEmpty()) {
                responseHeaders.set(key, value);
                continue;
            }
            LinkedHashSet<String> newValues = new LinkedHashSet<String>(oldValues);
            boolean added = newValues.add(value);
            if (!added) continue;
            responseHeaders.set(key, newValues);
        }
    }

    public static void applyHeaders(Map<String, HeaderConfig> headers, Router httpRouteRouter) {
        if (!headers.isEmpty()) {
            for (Map.Entry<String, HeaderConfig> entry : headers.entrySet()) {
                final String name = entry.getKey();
                final HeaderConfig config = entry.getValue();
                if (config.methods.isEmpty()) {
                    httpRouteRouter.route(config.path).order(Integer.MIN_VALUE).handler(new Handler<RoutingContext>(){

                        @Override
                        public void handle(RoutingContext event) {
                            event.response().headers().set(name, config.value);
                            event.next();
                        }
                    });
                    continue;
                }
                for (String method : config.methods.get()) {
                    httpRouteRouter.route(HttpMethod.valueOf(method.toUpperCase(Locale.ROOT)), config.path).order(Integer.MIN_VALUE).handler(new Handler<RoutingContext>(){

                        @Override
                        public void handle(RoutingContext event) {
                            event.response().headers().add(name, config.value);
                            event.next();
                        }
                    });
                }
            }
        }
    }
}

