/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.options;

import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.options.HttpServerOptionsUtils;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SSLOptions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class TlsCertificateReloader {
    private static final List<ReloadCertificateTask> TASKS = new CopyOnWriteArrayList<ReloadCertificateTask>();
    private static final Logger LOGGER = Logger.getLogger(TlsCertificateReloader.class);

    public static long initCertReloadingAction(final Vertx vertx, final HttpServer server, HttpServerOptions options, final ServerSslConfig configuration, TlsConfigurationRegistry registry, Optional<String> tlsConfigurationName) {
        if (options == null) {
            throw new IllegalArgumentException("Unable to configure TLS reloading - The HTTP server options were not provided");
        }
        boolean useRegistry = false;
        if (tlsConfigurationName.isPresent()) {
            useRegistry = true;
        } else if (registry.getDefault().isPresent() && registry.getDefault().get().getKeyStoreOptions() != null) {
            useRegistry = true;
        }
        SSLOptions ssl = null;
        TlsConfiguration tlsConfiguration = null;
        if (!useRegistry) {
            ssl = options.getSslOptions();
            if (ssl == null) {
                throw new IllegalArgumentException("Unable to configure TLS reloading - TLS/SSL is not enabled on the server");
            }
        } else {
            tlsConfiguration = tlsConfigurationName.isPresent() ? registry.get(tlsConfigurationName.get()).orElseThrow() : registry.getDefault().orElseThrow();
        }
        if (configuration.certificate.reloadPeriod.isPresent()) {
            if (configuration.certificate.reloadPeriod.get().toMillis() < 30000L) {
                throw new IllegalArgumentException("Unable to configure TLS reloading - The reload period cannot be less than 30 seconds");
            }
        } else {
            return -1L;
        }
        long period = configuration.certificate.reloadPeriod.get().toMillis();
        final boolean reloadFromRegistry = useRegistry;
        final TlsConfiguration registryConfiguration = tlsConfiguration;
        final SSLOptions nonRegistryOptions = ssl;
        final Supplier<CompletionStage<Boolean>> task = new Supplier<CompletionStage<Boolean>>(){

            @Override
            public CompletionStage<Boolean> get() {
                Future<Boolean> future = vertx.executeBlocking(new Callable<SSLOptions>(){

                    @Override
                    public SSLOptions call() throws Exception {
                        if (reloadFromRegistry) {
                            if (registryConfiguration.reload()) {
                                return registryConfiguration.getSSLOptions();
                            }
                            return null;
                        }
                        SSLOptions c = TlsCertificateReloader.reloadFileContent(nonRegistryOptions, configuration);
                        if (c.equals(nonRegistryOptions)) {
                            return null;
                        }
                        return c;
                    }
                }, true).flatMap(new Function<SSLOptions, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(SSLOptions res) {
                        if (res != null) {
                            return server.updateSSLOptions(res);
                        }
                        return Future.succeededFuture(false);
                    }
                }).onComplete(new Handler<AsyncResult<Boolean>>(){

                    @Override
                    public void handle(AsyncResult<Boolean> ar) {
                        if (ar.failed()) {
                            LOGGER.error((Object)"Unable to reload the TLS certificate, keeping the current one.", ar.cause());
                        } else if (ar.result().booleanValue()) {
                            LOGGER.debug("TLS certificates updated");
                        }
                    }
                });
                return future.toCompletionStage();
            }
        };
        long id = vertx.setPeriodic(period, new Handler<Long>(){

            @Override
            public void handle(Long id) {
                task.get();
            }
        });
        TASKS.add(new ReloadCertificateTask(id, task));
        return id;
    }

    public static void unschedule(Vertx vertx, long id) {
        vertx.cancelTimer(id);
        for (ReloadCertificateTask task : TASKS) {
            if (task.it != id) continue;
            TASKS.remove(task);
            break;
        }
    }

    public static CompletionStage<Void> reload() {
        CompletableFuture[] futures = new CompletableFuture[TASKS.size()];
        for (int i = 0; i < TASKS.size(); ++i) {
            futures[i] = TASKS.get(i).action().get().toCompletableFuture();
        }
        return CompletableFuture.allOf(futures);
    }

    private static SSLOptions reloadFileContent(SSLOptions ssl, ServerSslConfig configuration) throws IOException {
        KeyStoreOptions opts;
        SSLOptions copy = new SSLOptions(ssl);
        ArrayList keys = new ArrayList();
        ArrayList certificates = new ArrayList();
        configuration.certificate.keyFiles.ifPresent(keys::addAll);
        configuration.certificate.files.ifPresent(certificates::addAll);
        if (!certificates.isEmpty() && !keys.isEmpty()) {
            ArrayList<Buffer> certBuffer = new ArrayList<Buffer>();
            ArrayList<Buffer> keysBuffer = new ArrayList<Buffer>();
            for (Path p : certificates) {
                byte[] cert = HttpServerOptionsUtils.getFileContent(p);
                certBuffer.add(Buffer.buffer(cert));
            }
            for (Path p : keys) {
                byte[] key = HttpServerOptionsUtils.getFileContent(p);
                keysBuffer.add(Buffer.buffer(key));
            }
            PemKeyCertOptions opts2 = new PemKeyCertOptions().setCertValues(certBuffer).setKeyValues(keysBuffer);
            copy.setKeyCertOptions(opts2);
        } else if (configuration.certificate.keyStoreFile.isPresent()) {
            opts = (KeyStoreOptions)copy.getKeyCertOptions();
            opts.setValue(Buffer.buffer(HttpServerOptionsUtils.getFileContent(configuration.certificate.keyStoreFile.get())));
            copy.setKeyCertOptions(opts);
        }
        if (configuration.certificate.trustStoreFile.isPresent()) {
            opts = (KeyStoreOptions)copy.getTrustOptions();
            opts.setValue(Buffer.buffer(HttpServerOptionsUtils.getFileContent(configuration.certificate.trustStoreFile.get())));
            copy.setTrustOptions(opts);
        }
        return copy;
    }

    static final class ReloadCertificateTask {
        private final long it;
        private final Supplier<CompletionStage<Boolean>> action;

        ReloadCertificateTask(long it, Supplier<CompletionStage<Boolean>> action) {
            this.it = it;
            this.action = action;
        }

        public long it() {
            return this.it;
        }

        public Supplier<CompletionStage<Boolean>> action() {
            return this.action;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ReloadCertificateTask that = (ReloadCertificateTask)obj;
            return this.it == that.it && Objects.equals(this.action, that.action);
        }

        public int hashCode() {
            return Objects.hash(this.it, this.action);
        }

        public String toString() {
            return "ReloadCertificateTask[it=" + this.it + ", action=" + String.valueOf(this.action) + "]";
        }
    }
}

