/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

abstract class AbstractHttpAuthorizer {
    private static final Logger log = Logger.getLogger(AbstractHttpAuthorizer.class);
    private final HttpAuthenticator httpAuthenticator;
    private final IdentityProviderManager identityProviderManager;
    private final AuthorizationController controller;
    private final List<HttpSecurityPolicy> policies;
    private final SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> securityEventHelper;
    private final HttpSecurityPolicy.AuthorizationRequestContext context;

    AbstractHttpAuthorizer(HttpAuthenticator httpAuthenticator, IdentityProviderManager identityProviderManager, AuthorizationController controller, List<HttpSecurityPolicy> policies, BeanManager beanManager, BlockingSecurityExecutor blockingExecutor, Event<AuthorizationFailureEvent> authZFailureEvent, Event<AuthorizationSuccessEvent> authZSuccessEvent, boolean securityEventsEnabled) {
        this.httpAuthenticator = httpAuthenticator;
        this.identityProviderManager = identityProviderManager;
        this.controller = controller;
        this.policies = policies;
        this.context = new HttpSecurityPolicy.DefaultAuthorizationRequestContext(blockingExecutor);
        this.securityEventHelper = new SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent>(authZSuccessEvent, authZFailureEvent, SecurityEventHelper.AUTHORIZATION_SUCCESS, SecurityEventHelper.AUTHORIZATION_FAILURE, beanManager, securityEventsEnabled);
    }

    public void checkPermission(RoutingContext routingContext) {
        if (!this.controller.isAuthorizationEnabled()) {
            routingContext.next();
            return;
        }
        this.doPermissionCheck(routingContext, QuarkusHttpUser.getSecurityIdentity(routingContext, this.identityProviderManager), 0, null, this.policies);
    }

    private void doPermissionCheck(final RoutingContext routingContext, final Uni<SecurityIdentity> identity, final int index, final SecurityIdentity augmentedIdentity, final List<HttpSecurityPolicy> permissionCheckers) {
        if (index == permissionCheckers.size()) {
            QuarkusHttpUser currentUser = (QuarkusHttpUser)routingContext.user();
            if (augmentedIdentity != null) {
                if (!(augmentedIdentity.isAnonymous() || currentUser != null && currentUser.getSecurityIdentity() == augmentedIdentity)) {
                    QuarkusHttpUser.setIdentity(augmentedIdentity, routingContext);
                }
                if (this.securityEventHelper.fireEventOnSuccess()) {
                    this.securityEventHelper.fireSuccessEvent(new AuthorizationSuccessEvent(augmentedIdentity, Map.of(RoutingContext.class.getName(), routingContext)));
                }
            } else if (this.securityEventHelper.fireEventOnSuccess() && AbstractHttpAuthorizer.permissionCheckPerformed(permissionCheckers, routingContext, index)) {
                this.securityEventHelper.fireSuccessEvent(new AuthorizationSuccessEvent(currentUser == null ? null : currentUser.getSecurityIdentity(), Map.of(RoutingContext.class.getName(), routingContext)));
            }
            routingContext.next();
            return;
        }
        final HttpSecurityPolicy res = permissionCheckers.get(index);
        res.checkPermission(routingContext, identity, this.context).subscribe().with(new Consumer<HttpSecurityPolicy.CheckResult>(){

            @Override
            public void accept(HttpSecurityPolicy.CheckResult checkResult) {
                if (!checkResult.isPermitted()) {
                    AbstractHttpAuthorizer.this.doDeny(identity, routingContext, res, checkResult.getAugmentedIdentity());
                } else if (checkResult.getAugmentedIdentity() != null) {
                    AbstractHttpAuthorizer.this.doPermissionCheck(routingContext, checkResult.getAugmentedIdentityAsUni(), index + 1, checkResult.getAugmentedIdentity(), permissionCheckers);
                } else {
                    AbstractHttpAuthorizer.this.doPermissionCheck(routingContext, identity, index + 1, augmentedIdentity, permissionCheckers);
                }
            }
        }, new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                if (!routingContext.response().ended() && !throwable.equals(routingContext.failure())) {
                    routingContext.fail(throwable);
                } else if (throwable instanceof AuthenticationFailedException) {
                    log.debug("Authentication challenge is required");
                } else if (throwable instanceof AuthenticationRedirectException) {
                    log.debugf("Completing authentication with a redirect to %s", (Object)((AuthenticationRedirectException)throwable).getRedirectUri());
                } else {
                    log.error((Object)"Exception occurred during authorization", throwable);
                }
            }
        });
    }

    private void doDeny(final SecurityIdentity identity, final RoutingContext routingContext, final HttpSecurityPolicy policy) {
        if (identity.isAnonymous()) {
            this.httpAuthenticator.sendChallenge(routingContext).subscribe().withSubscriber(new UniSubscriber<Boolean>(){

                @Override
                public void onSubscribe(UniSubscription subscription) {
                }

                @Override
                public void onItem(Boolean item) {
                    if (!routingContext.response().ended()) {
                        routingContext.response().end();
                    }
                    AbstractHttpAuthorizer.this.fireAuthZFailureEvent(routingContext, policy, null, identity);
                }

                @Override
                public void onFailure(Throwable failure) {
                    AbstractHttpAuthorizer.this.fireAuthZFailureEvent(routingContext, policy, failure, identity);
                    if (!routingContext.response().ended()) {
                        routingContext.fail(failure);
                    } else if (!(failure instanceof IOException)) {
                        log.error((Object)"Failed to send challenge", failure);
                    } else {
                        log.debug((Object)"Failed to send challenge", failure);
                    }
                }
            });
        } else {
            ForbiddenException forbiddenException = new ForbiddenException();
            this.fireAuthZFailureEvent(routingContext, policy, forbiddenException, identity);
            routingContext.fail(new ForbiddenException());
        }
    }

    private void doDeny(Uni<SecurityIdentity> identity, final RoutingContext routingContext, final HttpSecurityPolicy policy, SecurityIdentity augmentedIdentity) {
        if (augmentedIdentity == null) {
            identity.subscribe().withSubscriber(new UniSubscriber<SecurityIdentity>(){

                @Override
                public void onSubscribe(UniSubscription subscription) {
                }

                @Override
                public void onItem(SecurityIdentity identity) {
                    AbstractHttpAuthorizer.this.doDeny(identity, routingContext, policy);
                }

                @Override
                public void onFailure(Throwable failure) {
                    AbstractHttpAuthorizer.this.fireAuthZFailureEvent(routingContext, policy, failure, null);
                    routingContext.fail(failure);
                }
            });
        } else {
            this.doDeny(augmentedIdentity, routingContext, policy);
        }
    }

    private void fireAuthZFailureEvent(RoutingContext routingContext, HttpSecurityPolicy policy, Throwable failure, SecurityIdentity identity) {
        if (this.securityEventHelper.fireEventOnFailure()) {
            String context = policy != null ? policy.getClass().getName() : null;
            AuthorizationFailureEvent event = new AuthorizationFailureEvent(identity, failure, context, Map.of(RoutingContext.class.getName(), routingContext));
            this.securityEventHelper.fireFailureEvent(event);
        }
    }

    private static boolean permissionCheckPerformed(List<HttpSecurityPolicy> permissionCheckers, RoutingContext routingContext, int index) {
        if (index == 1 && permissionCheckers.get(0) instanceof AbstractPathMatchingHttpSecurityPolicy) {
            return AbstractPathMatchingHttpSecurityPolicy.policyApplied(routingContext);
        }
        return index > 0;
    }
}

