/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.vertx.ext.auth.impl.asn.ASN1;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.security.auth.x500.X500Principal;
import org.jboss.logging.Logger;

public record CertificateRoleAttribute(Function<X509Certificate, Set<String>> rolesMapper) {
    private static final Logger log = Logger.getLogger(CertificateRoleAttribute.class);
    private static final String SAN_PREFIX = "SAN_";

    CertificateRoleAttribute(String configValue, Map<String, Set<String>> roles) {
        this(CertificateRoleAttribute.of(configValue.toUpperCase(), Map.copyOf(roles)));
    }

    private static Function<X509Certificate, Set<String>> of(final String configValue, final Map<String, Set<String>> roles) {
        if (configValue.contains(SAN_PREFIX)) {
            return new Function<X509Certificate, Set<String>>(){

                @Override
                public Set<String> apply(X509Certificate certificate) {
                    return CertificateRoleAttribute.extractRolesFromCertSan(certificate, SAN.valueOf((String)configValue).generalNameType, roles);
                }
            };
        }
        return new Function<X509Certificate, Set<String>>(){

            @Override
            public Set<String> apply(X509Certificate certificate) {
                return CertificateRoleAttribute.extractRolesFromCertRdn(certificate, roles, configValue);
            }
        };
    }

    private static Set<String> extractRolesFromCertRdn(X509Certificate certificate, Map<String, Set<String>> roles, String rdnType) {
        Set<String> matchedRoles;
        X500Principal principal = certificate.getSubjectX500Principal();
        if (principal == null || principal.getName() == null) {
            return Set.of();
        }
        if ("CN".equals(rdnType) && (matchedRoles = roles.get(principal.getName())) != null) {
            return matchedRoles;
        }
        String rdnValue = HttpSecurityUtils.getRdnValue(principal, rdnType);
        if (rdnValue != null && (matchedRoles = roles.get(rdnValue)) != null) {
            return matchedRoles;
        }
        return Set.of();
    }

    private static Set<String> extractRolesFromCertSan(X509Certificate certificate, int generalNameType, Map<String, Set<String>> roles) {
        HashSet result;
        block8: {
            result = new HashSet();
            try {
                Collection<List<?>> sanList = certificate.getSubjectAlternativeNames();
                if (sanList == null || sanList.isEmpty()) break block8;
                for (List<?> objects : sanList) {
                    Object obj;
                    if (objects != null && objects.size() >= 2 && (obj = objects.get(0)) instanceof Integer) {
                        byte[] byteArr;
                        ASN1.ASN asn1;
                        Object obj2;
                        Integer thatGeneralNameType = (Integer)obj;
                        if (thatGeneralNameType != generalNameType) continue;
                        if (thatGeneralNameType == 0 && (obj2 = objects.get(1)) instanceof byte[] && (asn1 = ASN1.parseASN1(byteArr = (byte[])obj2)).is(16) && asn1.length() == 2) {
                            String value;
                            ASN1.ASN otherIdentifier = asn1.object(1);
                            while (otherIdentifier.length() == 1 && otherIdentifier.is(128)) {
                                otherIdentifier = otherIdentifier.object(0);
                            }
                            if (otherIdentifier.is(12) && roles.containsKey(value = new String(otherIdentifier.binary(0), StandardCharsets.UTF_8))) {
                                result.addAll(roles.get(value));
                                break;
                            }
                        }
                        for (int i = 1; i < objects.size(); ++i) {
                            String name;
                            Object obj3 = objects.get(i);
                            if (!(obj3 instanceof String) || !roles.containsKey(name = (String)obj3)) continue;
                            result.addAll(roles.get(name));
                        }
                        continue;
                    }
                    log.tracef("Cannot map SecurityIdentity roles from '%s' due to unsupported format", (Object)objects);
                    break;
                }
            }
            catch (CertificateParsingException e) {
                log.tracef("Cannot map SecurityIdentity roles as certificate parsing failed", new Object[0]);
            }
        }
        return Set.copyOf(result);
    }

    private static enum SAN {
        SAN_ANY(0),
        SAN_RFC822(1),
        SAN_URI(6);

        private final int generalNameType;

        private SAN(int generalNameType) {
            this.generalNameType = generalNameType;
        }
    }
}

