/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.credential.CertificateCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.CertificateAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class MtlsAuthenticationMechanism
implements HttpAuthenticationMechanism {
    public static final int INCLUSIVE_AUTHENTICATION_PRIORITY = 3000;
    private static final String ROLES_MAPPER_ATTRIBUTE = "roles_mapper";
    private final boolean inclusiveAuthentication;
    private Function<X509Certificate, Set<String>> certificateToRoles = null;

    MtlsAuthenticationMechanism(@ConfigProperty(name="quarkus.http.auth.inclusive") boolean inclusiveAuthentication) {
        this.inclusiveAuthentication = inclusiveAuthentication;
    }

    @Override
    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        Certificate certificate;
        HttpServerRequest request = context.request();
        if (!request.isSSL()) {
            return Uni.createFrom().nullItem();
        }
        try {
            certificate = request.sslSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException e) {
            return Uni.createFrom().nullItem();
        }
        context.put(HttpAuthenticationMechanism.class.getName(), this);
        CertificateAuthenticationRequest authRequest = new CertificateAuthenticationRequest(new CertificateCredential((X509Certificate)certificate));
        authRequest.setAttribute(ROLES_MAPPER_ATTRIBUTE, this.certificateToRoles);
        return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute(authRequest, context));
    }

    @Override
    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return Uni.createFrom().item(new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), null, null));
    }

    @Override
    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(CertificateAuthenticationRequest.class);
    }

    @Override
    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        return Uni.createFrom().item(new HttpCredentialTransport(HttpCredentialTransport.Type.X509, "X509"));
    }

    @Override
    public int getPriority() {
        return this.inclusiveAuthentication ? 3000 : 1000;
    }

    void setCertificateToRolesMapper(Function<X509Certificate, Set<String>> certificateToRoles) {
        this.certificateToRoles = certificateToRoles;
    }
}

