/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class VertxBlockingSecurityExecutor
implements BlockingSecurityExecutor {
    @Inject
    Vertx vertx;

    @Override
    public <T> Uni<T> executeBlocking(final Supplier<? extends T> supplier) {
        return Uni.createFrom().deferred(new Supplier<Uni<? extends T>>(){

            @Override
            public Uni<? extends T> get() {
                if (BlockingOperationControl.isBlockingAllowed()) {
                    try {
                        return Uni.createFrom().item(supplier.get());
                    }
                    catch (Throwable t) {
                        return Uni.createFrom().failure(t);
                    }
                }
                Context local = VertxContext.getOrCreateDuplicatedContext(VertxBlockingSecurityExecutor.this.vertx);
                VertxContextSafetyToggle.setContextSafe(local, true);
                return Uni.createFrom().completionStage(local.executeBlocking(new Callable<T>(){

                    @Override
                    public T call() {
                        return supplier.get();
                    }
                }, false).toCompletionStage());
            }
        });
    }
}

