/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.utils.StringUtil;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Function;

@Documented
@Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ConfigMapping {
    public String prefix() default "";

    public NamingStrategy namingStrategy() default NamingStrategy.KEBAB_CASE;

    public boolean beanStyleGetters() default false;

    public static enum NamingStrategy implements Function<String, String>
    {
        VERBATIM(name -> name),
        KEBAB_CASE(name -> StringUtil.skewer(name, '-')),
        SNAKE_CASE(name -> StringUtil.skewer(name, '_'));

        private final Function<String, String> function;

        private NamingStrategy(Function<String, String> function) {
            this.function = function;
        }

        @Override
        public String apply(String name) {
            return this.function.apply(name);
        }
    }
}

