/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.MetadataInjectionPoint;
import io.smallrye.config.inject.SecuritySupport;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConfigMappingInjectionBean<T>
implements Bean<T> {
    private final BeanManager bm;
    private final ConfigMappings.ConfigClass configClass;

    public ConfigMappingInjectionBean(ConfigMappings.ConfigClass configClass, BeanManager bm) {
        this.bm = bm;
        this.configClass = configClass;
    }

    @Override
    public Class<T> getBeanClass() {
        return this.configClass.getKlass();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        ConfigMapping configMapping;
        InjectionPoint injectionPoint = (InjectionPoint)this.bm.getInjectableReference(new MetadataInjectionPoint(), creationalContext);
        String prefix = this.configClass.getPrefix();
        if (injectionPoint != null && injectionPoint.getAnnotated() != null && (configMapping = injectionPoint.getAnnotated().getAnnotation(ConfigMapping.class)) != null) {
            prefix = configMapping.prefix();
        }
        SmallRyeConfig config = ConfigProvider.getConfig(SecuritySupport.getContextClassLoader()).unwrap(SmallRyeConfig.class);
        return config.getConfigMapping(this.getBeanClass(), prefix);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public Set<Type> getTypes() {
        return Collections.singleton(this.configClass.getKlass());
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return Collections.singleton(Default.Literal.INSTANCE);
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + "_" + this.configClass.getKlass().getName();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }
}

