/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.SmallRyeContextManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.eclipse.microprofile.context.spi.ContextManagerProviderRegistration;

public class SmallRyeContextManagerProvider
implements ContextManagerProvider {
    private static ContextManagerProviderRegistration registration;
    private Map<ClassLoader, SmallRyeContextManager> contextManagersForClassLoader = new HashMap<ClassLoader, SmallRyeContextManager>();

    @Deprecated
    public static void register() {
        if (registration == null) {
            registration = ContextManagerProvider.register(new SmallRyeContextManagerProvider());
        }
    }

    @Deprecated
    public static void unregister() {
        registration.unregister();
        registration = null;
    }

    @Override
    public SmallRyeContextManager getContextManager() {
        return this.getContextManager(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmallRyeContextManager getContextManager(ClassLoader classLoader) {
        SmallRyeContextManager config = this.contextManagersForClassLoader.get(classLoader);
        if (config == null) {
            SmallRyeContextManagerProvider smallRyeContextManagerProvider = this;
            synchronized (smallRyeContextManagerProvider) {
                config = this.contextManagersForClassLoader.get(classLoader);
                if (config == null) {
                    config = this.getContextManagerBuilder().forClassLoader(classLoader).registerOnProvider().addDiscoveredThreadContextProviders().addDiscoveredContextManagerExtensions().build();
                }
            }
        }
        return config;
    }

    @Override
    public SmallRyeContextManager.Builder getContextManagerBuilder() {
        return new SmallRyeContextManager.Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContextManager(ContextManager manager, ClassLoader classLoader) {
        if (!(manager instanceof SmallRyeContextManager)) {
            throw new IllegalArgumentException("Only instances of SmallRyeContextManager are supported: " + String.valueOf(manager));
        }
        SmallRyeContextManagerProvider smallRyeContextManagerProvider = this;
        synchronized (smallRyeContextManagerProvider) {
            this.contextManagersForClassLoader.put(classLoader, (SmallRyeContextManager)manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseContextManager(ContextManager manager) {
        SmallRyeContextManagerProvider smallRyeContextManagerProvider = this;
        synchronized (smallRyeContextManagerProvider) {
            Iterator<Map.Entry<ClassLoader, SmallRyeContextManager>> iterator = this.contextManagersForClassLoader.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ClassLoader, SmallRyeContextManager> entry = iterator.next();
                if (entry.getValue() != manager) continue;
                iterator.remove();
                return;
            }
        }
    }

    public ContextManager findContextManager(ClassLoader classLoader) {
        return this.contextManagersForClassLoader.get(classLoader);
    }

    public static SmallRyeContextManager getManager() {
        return SmallRyeContextManagerProvider.instance().getContextManager();
    }

    public static SmallRyeContextManagerProvider instance() {
        return (SmallRyeContextManagerProvider)ContextManagerProvider.instance();
    }
}

