/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.AbstractKeyLocationResolver;
import io.smallrye.jwt.auth.principal.AwsAlbKeyConfigurationValidator;
import io.smallrye.jwt.auth.principal.AwsAlbKeyResolverLogging;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.PrincipalLogging;
import io.smallrye.jwt.auth.principal.PrincipalMessages;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import java.io.IOException;
import java.security.Key;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.http.SimpleResponse;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class AwsAlbKeyResolver
implements VerificationKeyResolver {
    private JWTAuthContextInfo authContextInfo;
    private long cacheTimeToLive;
    private Map<String, CacheEntry> keys = new HashMap<String, CacheEntry>();
    private AtomicInteger size = new AtomicInteger();

    public AwsAlbKeyResolver(JWTAuthContextInfo authContextInfo) throws UnresolvableKeyException {
        AwsAlbKeyConfigurationValidator.validateKeyConfiguration(authContextInfo);
        AwsAlbKeyConfigurationValidator.validatePublicKeyAlgorithmConfiguration(authContextInfo);
        AwsAlbKeyConfigurationValidator.validateTokenHeaderConfiguration(authContextInfo);
        this.authContextInfo = authContextInfo;
        this.cacheTimeToLive = Duration.ofMinutes(authContextInfo.getKeyCacheTimeToLive()).toMillis();
    }

    @Override
    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        String kid = jws.getHeaders().getStringHeaderValue("kid");
        this.verifyKid(kid);
        CacheEntry entry = this.findValidCacheEntry(kid);
        if (entry != null) {
            return entry.key;
        }
        if (this.prepareSpaceForNewCacheEntry()) {
            entry = new CacheEntry(this.retrieveKey(kid));
            this.keys.put(kid, entry);
            return entry.key;
        }
        return this.retrieveKey(kid);
    }

    protected Key retrieveKey(String kid) throws UnresolvableKeyException {
        String keyLocation = this.authContextInfo.getPublicKeyLocation() + "/" + kid;
        AwsAlbKeyResolverLogging.log.publicKeyPath(keyLocation);
        SimpleResponse simpleResponse = null;
        try {
            simpleResponse = this.getHttpGet().get(keyLocation);
        }
        catch (IOException ex) {
            AbstractKeyLocationResolver.reportLoadKeyException(null, keyLocation, ex);
        }
        String keyContent = simpleResponse.getBody();
        try {
            return KeyUtils.decodePublicKey(keyContent, this.authContextInfo.getSignatureAlgorithm().iterator().next());
        }
        catch (Exception e) {
            AbstractKeyLocationResolver.reportUnresolvableKeyException(keyContent, keyLocation);
            return null;
        }
    }

    protected SimpleGet getHttpGet() throws UnresolvableKeyException {
        Get httpGet = new Get();
        if (this.authContextInfo.isTlsTrustAll()) {
            httpGet.setHostnameVerifier(new AbstractKeyLocationResolver.TrustAllHostnameVerifier());
        } else if (this.authContextInfo.getTlsTrustedHosts() != null) {
            httpGet.setHostnameVerifier(new AbstractKeyLocationResolver.TrustedHostsHostnameVerifier(this.authContextInfo.getTlsTrustedHosts()));
        }
        if (this.authContextInfo.getTlsCertificate() != null) {
            httpGet.setTrustedCertificates(AbstractKeyLocationResolver.loadPEMCertificate(this.authContextInfo.getTlsCertificate()));
        } else if (this.authContextInfo.getTlsCertificatePath() != null) {
            httpGet.setTrustedCertificates(AbstractKeyLocationResolver.loadPEMCertificate(this.readKeyContent(this.authContextInfo.getTlsCertificatePath())));
        }
        return httpGet;
    }

    protected String readKeyContent(String keyLocation) throws UnresolvableKeyException {
        try {
            String content = ResourceUtils.readResource(keyLocation);
            if (content == null) {
                throw PrincipalMessages.msg.resourceNotFound(keyLocation);
            }
            return content;
        }
        catch (IOException ex) {
            AbstractKeyLocationResolver.reportLoadKeyException(null, keyLocation, ex);
            return null;
        }
    }

    private void verifyKid(String kid) throws UnresolvableKeyException {
        if (kid == null) {
            throw PrincipalMessages.msg.nullKeyIdentifier();
        }
        String expectedKid = this.authContextInfo.getTokenKeyId();
        if (expectedKid != null && !kid.equals(expectedKid)) {
            PrincipalLogging.log.invalidTokenKidHeader(kid, expectedKid);
            throw PrincipalMessages.msg.invalidTokenKid();
        }
    }

    private void removeInvalidEntries() {
        long now = AwsAlbKeyResolver.now();
        Iterator<Map.Entry<String, CacheEntry>> it = this.keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, CacheEntry> next = it.next();
            if (!this.isEntryExpired(next.getValue(), now)) continue;
            it.remove();
            this.size.decrementAndGet();
        }
    }

    private boolean prepareSpaceForNewCacheEntry() {
        int currentSize;
        do {
            if ((currentSize = this.size.get()) != this.authContextInfo.getKeyCacheSize()) continue;
            this.removeInvalidEntries();
            if (currentSize != this.authContextInfo.getKeyCacheSize()) continue;
            return false;
        } while (!this.size.compareAndSet(currentSize, currentSize + 1));
        return true;
    }

    private CacheEntry findValidCacheEntry(String kid) {
        long now;
        CacheEntry entry = this.keys.get(kid);
        if (entry != null && this.isEntryExpired(entry, now = AwsAlbKeyResolver.now())) {
            entry = null;
            this.keys.remove(kid);
            this.size.decrementAndGet();
        }
        return entry;
    }

    private boolean isEntryExpired(CacheEntry entry, long now) {
        return entry.createdTime + this.cacheTimeToLive < now;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static class CacheEntry {
        volatile Key key;
        long createdTime = System.currentTimeMillis();

        public CacheEntry(Key key) {
            this.key = key;
        }
    }
}

