/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.PrincipalLogging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;

public class PrincipalUtils {
    private static final String ROLE_MAPPINGS = "roleMappings";
    private static final Pattern CLAIM_PATH_PATTERN = Pattern.compile("\\/(?=(?:(?:[^\"]*\"){2})*[^\"]*$)");

    public static void setClaims(JwtClaims claimsSet, String token, JWTAuthContextInfo authContextInfo) {
        Object groupsClaim;
        claimsSet.setClaim(Claims.raw_token.name(), token);
        if (!claimsSet.hasClaim(Claims.sub.name())) {
            String sub = PrincipalUtils.findSubject(authContextInfo, claimsSet);
            claimsSet.setClaim(Claims.sub.name(), sub);
        }
        List<String> roles = authContextInfo.getGroupsPath() == null ? ((groupsClaim = claimsSet.getClaimValue(Claims.groups.name())) instanceof String ? PrincipalUtils.splitStringClaimValue(groupsClaim.toString(), authContextInfo) : (List<String>)List.class.cast(groupsClaim)) : PrincipalUtils.findGroups(authContextInfo, claimsSet);
        if (roles == null && authContextInfo.getDefaultGroupsClaim() != null) {
            roles = Collections.singletonList(authContextInfo.getDefaultGroupsClaim());
        }
        if (roles != null) {
            claimsSet.setClaim(Claims.groups.name(), roles);
        }
        if (claimsSet.hasClaim(ROLE_MAPPINGS)) {
            PrincipalUtils.mapRoles(claimsSet);
        }
    }

    private static String findSubject(JWTAuthContextInfo authContextInfo, JwtClaims claimsSet) {
        if (authContextInfo.getSubjectPath() != null) {
            String[] pathSegments = PrincipalUtils.splitClaimPath(authContextInfo.getSubjectPath());
            Object claimValue = PrincipalUtils.findClaimValue(authContextInfo.getSubjectPath(), claimsSet.getClaimsMap(), pathSegments, 0);
            if (claimValue instanceof String) {
                return (String)claimValue;
            }
            PrincipalLogging.log.claimAtPathIsNotAString(authContextInfo.getSubjectPath());
        }
        if (authContextInfo.getDefaultSubjectClaim() != null) {
            return authContextInfo.getDefaultSubjectClaim();
        }
        return null;
    }

    private static List<String> findGroups(JWTAuthContextInfo authContextInfo, JwtClaims claimsSet) {
        String[] pathSegments = PrincipalUtils.splitClaimPath(authContextInfo.getGroupsPath());
        Object claimValue = PrincipalUtils.findClaimValue(authContextInfo.getGroupsPath(), claimsSet.getClaimsMap(), pathSegments, 0);
        if (claimValue instanceof List) {
            List groups = (List)List.class.cast(claimValue);
            try {
                return Arrays.asList(groups.toArray(new String[0]));
            }
            catch (ArrayStoreException ex) {
                PrincipalLogging.log.claimAtPathIsNotAnArrayOfStrings(authContextInfo.getGroupsPath());
            }
        } else {
            if (claimValue instanceof String) {
                return PrincipalUtils.splitStringClaimValue(claimValue.toString(), authContextInfo);
            }
            PrincipalLogging.log.claimAtPathIsNeitherAnArrayOfStringsNorString(authContextInfo.getGroupsPath());
        }
        return null;
    }

    private static List<String> splitStringClaimValue(String claimValue, JWTAuthContextInfo authContextInfo) {
        return Arrays.asList(claimValue.split(authContextInfo.getGroupsSeparator()));
    }

    private static String[] splitClaimPath(String claimPath) {
        String[] stringArray;
        if (claimPath.indexOf(47) > 0) {
            stringArray = CLAIM_PATH_PATTERN.split(claimPath);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = claimPath;
        }
        return stringArray;
    }

    private static void mapRoles(JwtClaims claimsSet) {
        try {
            Map rolesMapping = claimsSet.getClaimValue(ROLE_MAPPINGS, Map.class);
            List<String> groups = claimsSet.getStringListClaimValue(Claims.groups.name());
            ArrayList<String> allGroups = new ArrayList<String>(groups);
            for (Map.Entry mapping : rolesMapping.entrySet()) {
                if (!groups.contains(mapping.getKey())) continue;
                allGroups.add((String)mapping.getValue());
            }
            claimsSet.setStringListClaim(Claims.groups.name(), allGroups);
            PrincipalLogging.log.updatedGroups(allGroups);
        }
        catch (Exception e) {
            PrincipalLogging.log.failedToAccessRolesMappingClaim(e);
        }
    }

    private static Object findClaimValue(String claimPath, Map<String, Object> claimsMap, String[] pathArray, int step) {
        Object claimValue = claimsMap.get(pathArray[step].replace("\"", ""));
        if (claimValue == null) {
            PrincipalLogging.log.claimNotFoundAtPathAtSegment(claimPath, pathArray[step]);
        } else if (step + 1 < pathArray.length) {
            if (claimValue instanceof Map) {
                Map nextMap = (Map)claimValue;
                int nextStep = step + 1;
                return PrincipalUtils.findClaimValue(claimPath, nextMap, pathArray, nextStep);
            }
            PrincipalLogging.log.claimValueIsNotAJson(claimPath);
            return null;
        }
        return claimValue;
    }
}

