/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.build.JwtEncryptionBuilder;
import io.smallrye.jwt.build.JwtSignature;
import io.smallrye.jwt.build.JwtSignatureException;
import io.smallrye.jwt.build.impl.ImplMessages;
import io.smallrye.jwt.build.impl.JwtBuildUtils;
import io.smallrye.jwt.build.impl.JwtEncryptionImpl;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;

class JwtSignatureImpl
implements JwtSignature {
    private static final String ED_EC_PRIVATE_KEY_INTERFACE = "java.security.interfaces.EdECPrivateKey";
    JwtClaims claims = new JwtClaims();
    Map<String, Object> headers = new HashMap<String, Object>();
    Long tokenLifespan;
    Key configuredPemKey;

    JwtSignatureImpl() {
    }

    JwtSignatureImpl(JwtClaims claims) {
        this.claims = claims;
    }

    @Override
    public String sign(PrivateKey signingKey) throws JwtSignatureException {
        return this.signInternal(signingKey);
    }

    @Override
    public String sign(SecretKey signingKey) throws JwtSignatureException {
        return this.signInternal(signingKey);
    }

    @Override
    public String sign(String keyLocation) throws JwtSignatureException {
        try {
            return this.signInternal(this.getSigningKeyFromKeyContent(JwtSignatureImpl.getKeyContentFromLocation(keyLocation)));
        }
        catch (JwtSignatureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ImplMessages.msg.signatureException(ex);
        }
    }

    @Override
    public String sign() throws JwtSignatureException {
        try {
            Key key = this.configuredPemKey;
            if (key == null) {
                String keyLocation = JwtBuildUtils.getConfigProperty("smallrye.jwt.sign.key.location", String.class);
                if (keyLocation != null) {
                    InputStream is;
                    key = JwtBuildUtils.readPrivateKeyFromKeystore(keyLocation.trim());
                    if (key == null && (is = ResourceUtils.getResourceStream(keyLocation.trim())) != null) {
                        try (InputStream keyStream = is;){
                            key = this.getSigningKeyFromKeyContent(new String(ResourceUtils.readBytes(keyStream)));
                        }
                    }
                } else {
                    key = JwtBuildUtils.readPrivateKeyFromKeystore(null);
                    if (key == null) {
                        String keyContent = JwtBuildUtils.getConfigProperty("smallrye.jwt.sign.key", String.class);
                        if (keyContent != null) {
                            key = this.getSigningKeyFromKeyContent(keyContent);
                        } else {
                            throw ImplMessages.msg.signKeyNotConfigured();
                        }
                    }
                }
            }
            if (key == null) {
                throw ImplMessages.msg.signingKeyCanNotBeCreatedFromContent();
            }
            String string = this.signInternal(key);
            return string;
        }
        catch (JwtSignatureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ImplMessages.msg.signatureException(ex);
        }
        finally {
            this.removeJti();
        }
    }

    @Override
    public String signWithSecret(String secret) throws JwtSignatureException {
        return this.sign(KeyUtils.createSecretKeyFromSecret(secret));
    }

    @Override
    public JwtEncryptionBuilder innerSign(PrivateKey signingKey) throws JwtSignatureException {
        return new JwtEncryptionImpl(this.sign(signingKey), true);
    }

    @Override
    public JwtEncryptionBuilder innerSign(SecretKey signingKey) throws JwtSignatureException {
        return new JwtEncryptionImpl(this.sign(signingKey), true);
    }

    @Override
    public JwtEncryptionBuilder innerSign(String keyLocation) throws JwtSignatureException {
        return new JwtEncryptionImpl(this.sign(keyLocation), true);
    }

    @Override
    public JwtEncryptionBuilder innerSign() throws JwtSignatureException {
        try {
            JwtEncryptionImpl jwtEncryptionImpl = new JwtEncryptionImpl(this.sign(), true);
            return jwtEncryptionImpl;
        }
        finally {
            this.removeJti();
        }
    }

    @Override
    public JwtEncryptionBuilder innerSignWithSecret(String secret) throws JwtSignatureException {
        return this.innerSign(KeyUtils.createSecretKeyFromSecret(secret));
    }

    private String signInternal(Key signingKey) {
        if (signingKey == null) {
            throw ImplMessages.msg.signingKeyIsNull();
        }
        JwtBuildUtils.setDefaultJwtClaims(this.claims, this.tokenLifespan);
        JsonWebSignature jws = new JsonWebSignature();
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            jws.setHeader(entry.getKey(), entry.getValue());
        }
        if (!this.headers.containsKey("typ")) {
            jws.setHeader("typ", "JWT");
        }
        String algorithm = this.getSignatureAlgorithm(signingKey);
        jws.setAlgorithmHeaderValue(algorithm);
        jws.setPayload(this.claims.toJson());
        jws.setKey(signingKey);
        if (this.isRelaxKeyValidation()) {
            jws.setDoKeyValidation(false);
        }
        try {
            return jws.getCompactSerialization();
        }
        catch (Exception ex) {
            throw ImplMessages.msg.signJwtTokenFailed(ex.getMessage(), ex);
        }
    }

    private boolean isRelaxKeyValidation() {
        return JwtBuildUtils.getConfigProperty("smallrye.jwt.sign.relax-key-validation", Boolean.class, false);
    }

    private String getConfiguredSignatureAlgorithm() {
        String alg = (String)this.headers.get("alg");
        if (alg == null) {
            try {
                alg = JwtBuildUtils.getConfigProperty("smallrye.jwt.new-token.signature-algorithm", String.class);
                if (alg != null) {
                    alg = SignatureAlgorithm.fromAlgorithm(alg).getAlgorithm();
                    this.headers.put("alg", alg);
                }
            }
            catch (Exception ex) {
                throw ImplMessages.msg.unsupportedSignatureAlgorithm(alg, ex);
            }
        }
        return alg;
    }

    private String getSignatureAlgorithm(Key signingKey) {
        String alg = this.getConfiguredSignatureAlgorithm();
        if ("none".equals(alg)) {
            throw ImplMessages.msg.noneSignatureAlgorithmUnsupported();
        }
        if (signingKey instanceof RSAPrivateKey) {
            if (alg == null) {
                return SignatureAlgorithm.RS256.name();
            }
            if (alg.startsWith("RS") || alg.startsWith("PS")) {
                return alg;
            }
        } else if (signingKey instanceof ECPrivateKey) {
            if (alg == null) {
                return SignatureAlgorithm.ES256.name();
            }
            if (alg.startsWith("ES")) {
                return alg;
            }
        } else if (signingKey instanceof SecretKey) {
            if (alg == null) {
                return SignatureAlgorithm.HS256.name();
            }
            if (alg.startsWith("HS")) {
                return alg;
            }
        } else if (signingKey instanceof PrivateKey) {
            if (JwtSignatureImpl.isEdECPrivateKey(signingKey) && (alg == null || alg.equals(SignatureAlgorithm.EDDSA.getAlgorithm()))) {
                return SignatureAlgorithm.EDDSA.getAlgorithm();
            }
            if (alg == null) {
                return SignatureAlgorithm.RS256.name();
            }
            if (alg.startsWith("RS") || alg.startsWith("PS") || alg.startsWith("ES")) {
                return alg;
            }
        }
        throw ImplMessages.msg.unsupportedSignatureAlgorithm(signingKey.getAlgorithm());
    }

    private static boolean isEdECPrivateKey(Key signingKey) {
        return KeyUtils.isSupportedKey(signingKey, ED_EC_PRIVATE_KEY_INTERFACE);
    }

    static String getKeyContentFromLocation(String keyLocation) {
        try {
            return KeyUtils.readKeyContent(keyLocation);
        }
        catch (Exception ex) {
            throw ImplMessages.msg.signingKeyCanNotBeLoadedFromLocation(keyLocation, ex);
        }
    }

    Key getSigningKeyFromKeyContent(String keyContent) {
        SignatureAlgorithm algorithm;
        String kid = (String)this.headers.get("kid");
        String alg = this.getConfiguredSignatureAlgorithm();
        try {
            algorithm = alg == null ? null : SignatureAlgorithm.fromAlgorithm(alg);
        }
        catch (IllegalArgumentException ex) {
            throw ImplMessages.msg.unsupportedSignatureAlgorithm(alg, ex);
        }
        Key key = KeyUtils.tryAsPemSigningPrivateKey(keyContent, algorithm == null ? SignatureAlgorithm.RS256 : algorithm);
        if (key == null) {
            JsonWebKey jwk;
            if (kid == null && (kid = JwtBuildUtils.getConfigProperty("smallrye.jwt.sign.key.id", String.class)) != null) {
                this.headers.put("kid", kid);
            }
            if ((jwk = KeyUtils.getJwkKeyFromJwkSet(kid, keyContent)) != null && (key = KeyUtils.getPrivateOrSecretSigningKey(jwk, algorithm)) != null) {
                if (algorithm == null && jwk.getAlgorithm() != null) {
                    this.headers.put("alg", jwk.getAlgorithm());
                }
                if (kid == null && jwk.getKeyId() != null) {
                    this.headers.put("kid", jwk.getKeyId());
                }
            }
        } else {
            this.configuredPemKey = key;
        }
        return key;
    }

    void removeJti() {
        this.claims.unsetClaim(Claims.jti.name());
    }
}

