/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SRJWT", length=5)
interface JWTUtilMessages {
    public static final JWTUtilMessages msg = Messages.getBundle(JWTUtilMessages.class);

    @Message(id=0, value="Failed to decode the JWKS Public Key")
    public UncheckedIOException invalidJWKSPublicKey(@Cause IOException var1);

    @Message(id=1, value="Unsupported key type %s")
    public NoSuchAlgorithmException unsupportedAlgorithm(String var1);

    @Message(id=2, value="No resource with the named %s location exists")
    public IOException keyNotFound(String var1);

    @Message(id=3, value="Algorithm %s is not a symmetric-key algorithm")
    public InvalidAlgorithmParameterException requiresSymmetricAlgo(String var1);

    @Message(id=4, value="Keystore provider %s is not found")
    public KeyStoreException keystoreProviderNotFound(String var1);
}

