/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.core;

import io.smallrye.mutiny.Uni;
import io.vertx.core.Expectation;
import java.util.function.Function;

public interface Expectations {
    public static <T> Function<Uni<T>, Uni<T>> expectation(Expectation<? super T> expectation) {
        return uni -> uni.onItem().transformToUni(item -> {
            if (expectation.test((Object)item)) {
                return Uni.createFrom().item(item);
            }
            return Uni.createFrom().failure(expectation.describe((Object)item));
        });
    }

    public static <T, R> Function<Uni<T>, Uni<T>> expectation(Function<T, R> extractor, Expectation<? super R> expectation) {
        return uni -> uni.onItem().transformToUni(item -> {
            Object unwrapped = extractor.apply(item);
            if (expectation.test((Object)unwrapped)) {
                return Uni.createFrom().item(item);
            }
            return Uni.createFrom().failure(expectation.describe((Object)unwrapped));
        });
    }
}

