/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.NoSuchServiceDefinitionException;
import io.smallrye.stork.api.NoSuchServiceRegistrarException;
import io.smallrye.stork.api.Service;
import io.smallrye.stork.api.ServiceDefinition;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.api.StorkServiceRegistry;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.impl.RoundRobinLoadBalancer;
import io.smallrye.stork.integration.DefaultStorkInfrastructure;
import io.smallrye.stork.spi.ElementWithType;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.spi.config.ConfigProvider;
import io.smallrye.stork.spi.config.SimpleServiceConfig;
import io.smallrye.stork.spi.internal.LoadBalancerLoader;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import io.smallrye.stork.spi.internal.ServiceRegistrarLoader;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Stork
implements StorkServiceRegistry {
    public static final String STORK = "stork";
    public static final String STORK_REGISTRAR = "stork-registrar";
    private static final Logger LOGGER = LoggerFactory.getLogger(Stork.class);
    private final Map<String, Service> services = new ConcurrentHashMap<String, Service>();
    private final Map<String, ServiceRegistrar> serviceRegistrars = new ConcurrentHashMap<String, ServiceRegistrar>();
    private final StorkInfrastructure infrastructure;
    private static final AtomicReference<Stork> REFERENCE = new AtomicReference();

    @Override
    public Service getService(String serviceName) {
        Service service = this.services.get(serviceName);
        if (service == null) {
            throw new NoSuchServiceDefinitionException(serviceName);
        }
        return service;
    }

    @Override
    public Optional<Service> getServiceOptional(String serviceName) {
        Service service = this.services.get(serviceName);
        return Optional.ofNullable(service);
    }

    @Override
    public Map<String, Service> getServices() {
        return Collections.unmodifiableMap(this.services);
    }

    @Override
    public Stork defineIfAbsent(String name, ServiceDefinition definition) {
        ParameterValidation.nonNull(name, "name");
        ParameterValidation.nonNull(definition, "definition");
        ServiceConfig config = this.toServiceConfig(name, definition);
        Service service = this.createService(config);
        this.services.putIfAbsent(name, service);
        service.getServiceDiscovery().initialize(this);
        return this;
    }

    private ServiceConfig toServiceConfig(String name, ServiceDefinition definition) {
        return new SimpleServiceConfig.Builder().setServiceName(name).setLoadBalancer(definition.getLoadBalancer()).setServiceDiscovery(definition.getServiceDiscovery()).build();
    }

    @Deprecated
    public Stork(StorkInfrastructure storkInfrastructure) {
        this.infrastructure = storkInfrastructure;
        Map<String, LoadBalancerLoader> loadBalancerLoaders = this.loadFromServiceLoader(LoadBalancerLoader.class);
        Map<String, ServiceDiscoveryLoader> serviceDiscoveryLoaders = this.loadFromServiceLoader(ServiceDiscoveryLoader.class);
        Map<String, ServiceRegistrarLoader> registrarLoaders = this.loadFromServiceLoader(ServiceRegistrarLoader.class);
        this.extendWithCdiLoaders(serviceDiscoveryLoaders, loadBalancerLoaders, registrarLoaders);
        ConfigProvider configProvider = Stork.lookForConfigProvider();
        if (configProvider != null) {
            for (ServiceConfig serviceConfig : configProvider.getConfigs()) {
                Service service = this.createService(loadBalancerLoaders, serviceDiscoveryLoaders, registrarLoaders, serviceConfig);
                this.services.put(serviceConfig.serviceName(), service);
            }
            for (Service service : this.services.values()) {
                if (service.getServiceDiscovery() == null) continue;
                service.getServiceDiscovery().initialize(this);
            }
        }
    }

    private void extendWithCdiLoaders(Map<String, ServiceDiscoveryLoader> serviceDiscoveryLoaders, Map<String, LoadBalancerLoader> loadBalancerLoaders, Map<String, ServiceRegistrarLoader> registrarLoaders) {
        CDI<Object> cdi;
        try {
            cdi = CDI.current();
        }
        catch (IllegalStateException e) {
            return;
        }
        Instance<ServiceDiscoveryLoader> sdl = cdi.select(ServiceDiscoveryLoader.class, new Annotation[0]);
        Instance<LoadBalancerLoader> lbl = cdi.select(LoadBalancerLoader.class, new Annotation[0]);
        Instance<ServiceRegistrarLoader> srl = cdi.select(ServiceRegistrarLoader.class, new Annotation[0]);
        sdl.forEach(l -> serviceDiscoveryLoaders.put(l.type(), (ServiceDiscoveryLoader)l));
        lbl.forEach(l -> loadBalancerLoaders.put(l.type(), (LoadBalancerLoader)l));
        srl.forEach(l -> registrarLoaders.put(l.type(), (ServiceRegistrarLoader)l));
    }

    private static ConfigProvider lookForConfigProvider() {
        List providers = ServiceLoader.load(ConfigProvider.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        try {
            CDI<Object> cdi = CDI.current();
            providers.addAll(cdi.select(ConfigProvider.class, new Annotation[0]).stream().collect(Collectors.toList()));
        }
        catch (IllegalStateException cdi) {
            // empty catch block
        }
        Optional<ConfigProvider> highestPrioConfigProvider = providers.stream().max(Comparator.comparingInt(ConfigProvider::priority));
        return highestPrioConfigProvider.orElse(null);
    }

    private Service createService(ServiceConfig serviceConfig) {
        return this.createService(this.loadFromServiceLoader(LoadBalancerLoader.class), this.loadFromServiceLoader(ServiceDiscoveryLoader.class), this.loadFromServiceLoader(ServiceRegistrarLoader.class), serviceConfig);
    }

    private Service createService(Map<String, LoadBalancerLoader> loadBalancerLoaders, Map<String, ServiceDiscoveryLoader> serviceDiscoveryProviders, Map<String, ServiceRegistrarLoader> serviceRegistrarLoaders, ServiceConfig serviceConfig) {
        ConfigWithType serviceRegistrarConfig;
        ConfigWithType serviceDiscoveryConfig = serviceConfig.serviceDiscovery();
        Service.Builder serviceBuilder = new Service.Builder(this.infrastructure.getObservationCollector());
        if (serviceDiscoveryConfig != null && serviceDiscoveryConfig.type() == null) {
            throw new IllegalArgumentException("Service discovery type not defined for service " + serviceConfig.serviceName());
        }
        if (serviceDiscoveryConfig != null && serviceDiscoveryProviders.get(serviceDiscoveryConfig.type()) == null) {
            throw new IllegalArgumentException("ServiceDiscoveryProvider not found for type " + serviceDiscoveryConfig.type());
        }
        if (serviceConfig.secure()) {
            LOGGER.warn("The 'secure' attribute is deprecated, use the 'secure' service discovery attribute instead");
            if (serviceDiscoveryConfig != null) {
                HashMap<String, String> newConfig = new HashMap<String, String>(serviceDiscoveryConfig.parameters());
                newConfig.put("secure", "true");
                serviceDiscoveryConfig = new SimpleServiceConfig.SimpleServiceDiscoveryConfig(serviceDiscoveryConfig.type(), newConfig);
            }
        }
        if (serviceDiscoveryConfig != null) {
            LoadBalancer loadBalancer;
            String loadBalancerType;
            ServiceDiscoveryLoader serviceDiscoveryProvider = serviceDiscoveryProviders.get(serviceDiscoveryConfig.type());
            ServiceDiscovery serviceDiscovery = serviceDiscoveryProvider.createServiceDiscovery(serviceDiscoveryConfig, serviceConfig.serviceName(), serviceConfig, this.infrastructure);
            ConfigWithType loadBalancerConfig = serviceConfig.loadBalancer();
            if (loadBalancerConfig == null) {
                LOGGER.debug("No load balancer configured for type {}, using {}", (Object)serviceDiscoveryConfig.type(), (Object)"round-robin");
                loadBalancerType = "round-robin";
                loadBalancer = new RoundRobinLoadBalancer();
            } else {
                loadBalancerType = loadBalancerConfig.type();
                LoadBalancerLoader loadBalancerProvider = loadBalancerLoaders.get(loadBalancerType);
                if (loadBalancerProvider == null) {
                    throw new IllegalArgumentException("No LoadBalancerProvider for type " + loadBalancerType);
                }
                loadBalancer = loadBalancerProvider.createLoadBalancer(loadBalancerConfig, serviceDiscovery);
            }
            serviceBuilder = serviceBuilder.serviceName(serviceConfig.serviceName()).serviceDiscovery(serviceDiscovery).serviceSelectionType(loadBalancerType).serviceDiscoveryType(serviceDiscoveryConfig.type()).loadBalancer(loadBalancer).requiresStrictRecording(loadBalancer.requiresStrictRecording());
        }
        if ((serviceRegistrarConfig = serviceConfig.serviceRegistrar()) == null) {
            LOGGER.debug("No service registrar configured for service {}", (Object)serviceConfig.serviceName());
        } else {
            String serviceRegistrarType = serviceRegistrarConfig.type();
            ServiceRegistrarLoader serviceRegistrarLoader = serviceRegistrarLoaders.get(serviceRegistrarType);
            if (serviceRegistrarLoader == null) {
                throw new IllegalArgumentException("No ServiceRegistrarLoader for type " + serviceRegistrarType);
            }
            ServiceRegistrar serviceRegistrar = serviceRegistrarLoader.createServiceRegistrar(serviceRegistrarConfig, serviceConfig.serviceName(), this.infrastructure);
            serviceBuilder.serviceName(serviceConfig.serviceName()).serviceRegistrar(serviceRegistrar);
        }
        return serviceBuilder.build();
    }

    private <T extends ElementWithType> Map<String, T> loadFromServiceLoader(Class<T> loaderClass) {
        ServiceLoader<T> loader = ServiceLoader.load(loaderClass);
        return loader.stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(ElementWithType::type, Function.identity()));
    }

    public static Stork getInstance() {
        return REFERENCE.get();
    }

    public static void shutdown() {
        REFERENCE.set(null);
    }

    public static void initialize(StorkInfrastructure infrastructure) {
        REFERENCE.compareAndSet(null, new Stork(infrastructure));
    }

    public static void initialize() {
        Stork.initialize(new DefaultStorkInfrastructure());
    }

    @Deprecated
    public <MetadataKeyType extends Enum<MetadataKeyType>> ServiceRegistrar<MetadataKeyType> getServiceRegistrar(String registrarName) {
        ServiceRegistrar registrar = this.serviceRegistrars.get(registrarName);
        if (registrar == null) {
            throw new NoSuchServiceRegistrarException(registrarName);
        }
        return registrar;
    }
}

