/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.impl;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.utils.DurationUtils;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingServiceDiscovery
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(CachingServiceDiscovery.class);
    public static final String REFRESH_PERIOD = "refresh-period";
    public final Duration refreshPeriod;
    public static final String DEFAULT_REFRESH_INTERVAL = "5M";
    private volatile List<ServiceInstance> lastResults;
    private final Uni<List<ServiceInstance>> instances;

    public CachingServiceDiscovery(String refreshPeriod) {
        try {
            this.refreshPeriod = DurationUtils.parseDuration(refreshPeriod, REFRESH_PERIOD);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("refresh-period for service discovery should be a number, got: " + refreshPeriod, e);
        }
        this.lastResults = Collections.emptyList();
        Uni retrieval = Uni.createFrom().deferred(() -> this.fetchNewServiceInstances(this.lastResults).invoke(l -> {
            this.lastResults = l;
        }).onFailure().invoke(this::handleFetchError).onFailure().recoverWithItem(this.lastResults));
        this.instances = this.cache(retrieval);
    }

    public Uni<List<ServiceInstance>> cache(Uni<List<ServiceInstance>> uni) {
        return uni.memoize().atLeast(this.refreshPeriod);
    }

    @Override
    public Uni<List<ServiceInstance>> getServiceInstances() {
        return this.instances;
    }

    private void handleFetchError(Throwable error) {
        log.error("Failed to fetch service instances", error);
    }

    public abstract Uni<List<ServiceInstance>> fetchNewServiceInstances(List<ServiceInstance> var1);
}

