/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.impl;

import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.spi.CallStatisticsCollector;
import java.util.Optional;

public class ServiceInstanceWithStatGathering
implements ServiceInstance {
    private final ServiceInstance delegate;
    private final CallStatisticsCollector statistics;
    volatile long start;

    public ServiceInstanceWithStatGathering(ServiceInstance delegate, CallStatisticsCollector statistics) {
        this.delegate = delegate;
        this.statistics = statistics;
    }

    @Override
    public boolean gatherStatistics() {
        return true;
    }

    @Override
    public long getId() {
        return this.delegate.getId();
    }

    @Override
    public String getHost() {
        return this.delegate.getHost();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public Optional<String> getPath() {
        return this.delegate.getPath();
    }

    @Override
    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    @Override
    public void recordStart(boolean measureTime) {
        if (measureTime) {
            this.start = System.nanoTime();
        }
        this.statistics.recordStart(this.getId(), measureTime);
    }

    @Override
    public void recordReply() {
        this.statistics.recordReply(this.getId(), System.nanoTime() - this.start);
    }

    @Override
    public void recordEnd(Throwable failure) {
        this.statistics.recordEnd(this.getId(), failure);
    }

    @Deprecated
    public void mockRecordingTime(long timeInNs) {
        this.statistics.recordReply(this.getId(), timeInNs);
    }
}

