/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.UserContext;
import io.vertx.ext.web.handler.HttpException;
import java.util.Objects;

public class UserContextImpl
implements UserContext {
    private static final String USER_SWITCH_KEY = "__vertx.user-switch-ref";
    private static final Logger LOG = LoggerFactory.getLogger(UserContext.class);
    private final RoutingContext ctx;
    private User user;

    public UserContextImpl(RoutingContext ctx) {
        this.ctx = ctx;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public User get() {
        return this.user;
    }

    @Override
    public UserContext loginHint(String loginHint) {
        Session session = this.ctx.session();
        if (session == null) {
            if (loginHint == null) {
                return this;
            }
            throw new IllegalStateException("SessionHandler not seen in the route. Sessions are required to keep the state");
        }
        if (loginHint == null) {
            session.remove("login_hint");
        } else {
            session.put("login_hint", loginHint);
        }
        return this;
    }

    @Override
    public Future<Void> impersonate() {
        if (!this.ctx.request().method().equals(HttpMethod.GET)) {
            return Future.failedFuture(new HttpException(405, "Method not allowed"));
        }
        return this.impersonate(this.ctx.request().absoluteURI());
    }

    @Override
    public Future<Void> impersonate(String redirectUri) {
        Objects.requireNonNull(redirectUri, "redirectUri cannot be null");
        if (this.user == null) {
            LOG.debug("Impersonation can only occur after a complete authn flow.");
            return Future.failedFuture(new HttpException(401));
        }
        Session session = this.ctx.session();
        if (session == null) {
            LOG.debug("SessionHandler not seen in the route. Sessions are required to keep the state");
            return Future.failedFuture(new HttpException(500));
        }
        if (session.get(USER_SWITCH_KEY) != null) {
            LOG.debug("Impersonation already in place");
            return Future.failedFuture(new HttpException(400));
        }
        session.put(USER_SWITCH_KEY, this.user).regenerateId();
        this.user = null;
        return this.ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)redirectUri).setStatusCode(302).end("Redirecting to " + redirectUri + ".");
    }

    @Override
    public Future<Void> restore() {
        if (!this.ctx.request().method().equals(HttpMethod.GET)) {
            return Future.failedFuture(new HttpException(405, "Method not allowed"));
        }
        return this.restore(this.ctx.request().absoluteURI());
    }

    @Override
    public Future<Void> restore(String redirectUri) {
        Objects.requireNonNull(redirectUri, "redirectUri cannot be null");
        if (this.user == null) {
            LOG.debug("Impersonation can only occur after a complete authn flow.");
            return Future.failedFuture(new HttpException(401));
        }
        Session session = this.ctx.session();
        if (session == null) {
            LOG.debug("SessionHandler not seen in the route. Sessions are required to keep the state");
            return Future.failedFuture(new HttpException(500));
        }
        if (session.get(USER_SWITCH_KEY) == null) {
            LOG.debug("No previous impersonation in place");
            return Future.failedFuture(new HttpException(400));
        }
        User previousUser = (User)session.get(USER_SWITCH_KEY);
        session.remove(USER_SWITCH_KEY);
        session.remove("login_hint");
        session.regenerateId();
        this.user = previousUser;
        return this.ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)redirectUri).setStatusCode(302).end("Redirecting to " + redirectUri + ".");
    }

    @Override
    public Future<Void> logout() {
        return this.logout("/");
    }

    @Override
    public Future<Void> logout(String redirectUri) {
        Objects.requireNonNull(redirectUri, "redirectUri cannot be null");
        Session session = this.ctx.session();
        if (session != null) {
            session.destroy();
        }
        this.user = null;
        return this.ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)redirectUri).setStatusCode(302).end("Redirecting to " + redirectUri + ".");
    }

    @Override
    public void clear() {
        Session session = this.ctx.session();
        if (session != null) {
            session.destroy();
        }
        this.user = null;
    }
}

