/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.parsetools;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.parsetools.JsonEvent;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.parsetools.JsonParser.class)
public class JsonParser
implements MutinyDelegate,
ReadStream<JsonEvent>,
Handler<Buffer>,
Consumer<Buffer> {
    public static final TypeArg<JsonParser> __TYPE_ARG = new TypeArg<JsonParser>(obj -> new JsonParser((io.vertx.core.parsetools.JsonParser)obj), JsonParser::getDelegate);
    private final io.vertx.core.parsetools.JsonParser delegate;
    static final TypeArg<JsonEvent> TYPE_ARG_0 = new TypeArg<JsonEvent>(o1 -> JsonEvent.newInstance((io.vertx.core.parsetools.JsonEvent)o1), o1 -> o1.getDelegate());
    private Multi<JsonEvent> multi;

    public JsonParser(io.vertx.core.parsetools.JsonParser delegate) {
        this.delegate = delegate;
    }

    public JsonParser(Object delegate) {
        this.delegate = (io.vertx.core.parsetools.JsonParser)delegate;
    }

    JsonParser() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.parsetools.JsonParser getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonParser that = (JsonParser)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public void handle(Buffer event) {
        this.delegate.handle(event.getDelegate());
    }

    @Override
    public Pipe<JsonEvent> pipe() {
        Pipe<JsonEvent> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<JsonEvent> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<JsonEvent> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<JsonEvent> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    public static JsonParser newParser() {
        JsonParser ret = JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser());
        return ret;
    }

    public static JsonParser newParser(ReadStream<Buffer> stream) {
        JsonParser ret = JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser(stream.getDelegate()));
        return ret;
    }

    public static JsonParser newParser(Flow.Publisher<Buffer> stream) {
        JsonParser ret = JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser(ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
        return ret;
    }

    @Fluent
    public JsonParser write(Buffer buffer) {
        this.delegate.write(buffer.getDelegate());
        return this;
    }

    public void end() {
        this.delegate.end();
    }

    @Fluent
    public JsonParser objectEventMode() {
        this.delegate.objectEventMode();
        return this;
    }

    @Fluent
    public JsonParser objectValueMode() {
        this.delegate.objectValueMode();
        return this;
    }

    @Fluent
    public JsonParser arrayEventMode() {
        this.delegate.arrayEventMode();
        return this;
    }

    @Fluent
    public JsonParser arrayValueMode() {
        this.delegate.arrayValueMode();
        return this;
    }

    @Fluent
    public JsonParser pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public JsonParser resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    public JsonParser fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    private JsonParser __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    public JsonParser endHandler(Runnable endHandler) {
        return this.__endHandler(ignored -> endHandler.run());
    }

    @Fluent
    private JsonParser __handler(Handler<JsonEvent> handler) {
        this.delegate.handler((Handler)MutinyHelper.convertHandler(handler, event -> JsonEvent.newInstance(event)));
        return this;
    }

    public JsonParser handler(Consumer<JsonEvent> handler) {
        return this.__handler(MutinyHelper.convertConsumer(handler));
    }

    @Fluent
    private JsonParser __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public JsonParser exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(MutinyHelper.convertConsumer(handler));
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<JsonEvent> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.parsetools.JsonEvent, JsonEvent> conv = JsonEvent::newInstance;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<JsonEvent> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<JsonEvent> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    @Override
    public void accept(Buffer item) {
        this.handle(item);
    }

    public static JsonParser newInstance(io.vertx.core.parsetools.JsonParser arg) {
        return arg != null ? new JsonParser(arg) : null;
    }
}

