/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.web;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.ext.auth.User;

@MutinyGen(value=io.vertx.ext.web.UserContext.class)
public class UserContext
implements MutinyDelegate {
    public static final TypeArg<UserContext> __TYPE_ARG = new TypeArg<UserContext>(obj -> new UserContext((io.vertx.ext.web.UserContext)obj), UserContext::getDelegate);
    private final io.vertx.ext.web.UserContext delegate;

    public UserContext(io.vertx.ext.web.UserContext delegate) {
        this.delegate = delegate;
    }

    public UserContext(Object delegate) {
        this.delegate = (io.vertx.ext.web.UserContext)delegate;
    }

    UserContext() {
        this.delegate = null;
    }

    @Override
    public io.vertx.ext.web.UserContext getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserContext that = (UserContext)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public User get() {
        User ret = User.newInstance(this.delegate.get());
        return ret;
    }

    public boolean authenticated() {
        boolean ret = this.delegate.authenticated();
        return ret;
    }

    @Fluent
    public UserContext loginHint(String loginHint) {
        this.delegate.loginHint(loginHint);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> impersonate() {
        return AsyncResultUni.toUni(callback -> this.delegate.impersonate((Handler<AsyncResult<Void>>)callback));
    }

    public Void impersonateAndAwait() {
        return this.impersonate().await().indefinitely();
    }

    public void impersonateAndForget() {
        this.impersonate().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> impersonate(String redirectUri) {
        return AsyncResultUni.toUni(callback -> this.delegate.impersonate(redirectUri, (Handler<AsyncResult<Void>>)callback));
    }

    public Void impersonateAndAwait(String redirectUri) {
        return this.impersonate(redirectUri).await().indefinitely();
    }

    public void impersonateAndForget(String redirectUri) {
        this.impersonate(redirectUri).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> restore() {
        return AsyncResultUni.toUni(callback -> this.delegate.restore((Handler<AsyncResult<Void>>)callback));
    }

    public Void restoreAndAwait() {
        return this.restore().await().indefinitely();
    }

    public void restoreAndForget() {
        this.restore().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> restore(String redirectUri) {
        return AsyncResultUni.toUni(callback -> this.delegate.restore(redirectUri, (Handler<AsyncResult<Void>>)callback));
    }

    public Void restoreAndAwait(String redirectUri) {
        return this.restore(redirectUri).await().indefinitely();
    }

    public void restoreAndForget(String redirectUri) {
        this.restore(redirectUri).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> logout(String redirectUri) {
        return AsyncResultUni.toUni(callback -> this.delegate.logout(redirectUri, (Handler<AsyncResult<Void>>)callback));
    }

    public Void logoutAndAwait(String redirectUri) {
        return this.logout(redirectUri).await().indefinitely();
    }

    public void logoutAndForget(String redirectUri) {
        this.logout(redirectUri).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> logout() {
        return AsyncResultUni.toUni(callback -> this.delegate.logout((Handler<AsyncResult<Void>>)callback));
    }

    public Void logoutAndAwait() {
        return this.logout().await().indefinitely();
    }

    public void logoutAndForget() {
        this.logout().subscribe().with(UniHelper.NOOP);
    }

    public void clear() {
        this.delegate.clear();
    }

    public static UserContext newInstance(io.vertx.ext.web.UserContext arg) {
        return arg != null ? new UserContext(arg) : null;
    }
}

