/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.invocation;

import java.io.Console;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.Executor;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.shell.Shell;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.Prompt;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.utils.ANSI;

public class DefaultCommandInvocation
implements CommandInvocation {
    private final Shell shell;
    private final CommandRuntime<DefaultCommandInvocation> processor;
    private final CommandInvocationConfiguration config;
    private final CommandContainer<DefaultCommandInvocation> commandContainer;

    public DefaultCommandInvocation(CommandRuntime<DefaultCommandInvocation> processor, CommandInvocationConfiguration config, CommandContainer<DefaultCommandInvocation> commandContainer, Shell shell) {
        this.processor = processor;
        this.config = config;
        this.commandContainer = commandContainer;
        this.shell = shell != null ? shell : new DefaultShell();
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public void setPrompt(Prompt prompt) {
    }

    @Override
    public Prompt getPrompt() {
        return null;
    }

    @Override
    public String getHelpInfo(String commandName) {
        return this.processor.commandInfo(commandName);
    }

    @Override
    public String getHelpInfo() {
        return this.commandContainer.getParser().parsedCommand().printHelp();
    }

    @Override
    public void stop() {
    }

    @Override
    public KeyAction input() {
        try {
            return this.getShell().read();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public KeyAction input(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return this.getShell().read(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public String inputLine() {
        return this.inputLine(null);
    }

    @Override
    public String inputLine(Prompt prompt) {
        try {
            return this.getShell().readLine(prompt);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public void executeCommand(String input) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException, IOException {
        this.processor.executeCommand(input);
    }

    @Override
    public void print(String msg, boolean paging) {
        this.shell.write(msg, paging);
    }

    @Override
    public void println(String msg, boolean paging) {
        this.shell.writeln(msg, paging);
    }

    @Override
    public Executor<? extends CommandInvocation> buildExecutor(String line) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException {
        return this.processor.buildExecutor(line);
    }

    @Override
    public CommandInvocationConfiguration getConfiguration() {
        return this.config;
    }

    private static class DefaultShell
    implements Shell {
        private DefaultShell() {
        }

        @Override
        public void write(String out, boolean paging) {
            System.out.print(out);
        }

        @Override
        public void writeln(String out, boolean paging) {
            System.out.println(out);
        }

        @Override
        public void write(int[] out) {
            Console console = System.console();
            if (console != null) {
                console.writer().write(Parser.fromCodePoints(out));
                console.writer().flush();
            }
        }

        @Override
        public void write(char out) {
            System.out.println(out);
        }

        @Override
        public String readLine() {
            return this.readLine(new Prompt());
        }

        @Override
        public String readLine(Prompt prompt) {
            Console console = System.console();
            if (console != null) {
                if (prompt != null) {
                    console.writer().print(Parser.fromCodePoints(prompt.getANSI()));
                    console.writer().flush();
                    if (prompt.isMasking()) {
                        return new String(console.readPassword());
                    }
                }
                return console.readLine();
            }
            return null;
        }

        @Override
        public Key read() {
            return this.read(null);
        }

        @Override
        public Key read(long timeout, TimeUnit unit) throws InterruptedException {
            return this.read(null);
        }

        @Override
        public Key read(Prompt prompt) {
            Console console = System.console();
            if (console != null) {
                try {
                    if (prompt != null) {
                        console.writer().print(Parser.fromCodePoints(prompt.getANSI()));
                        console.writer().flush();
                    }
                    int input = console.reader().read();
                    return Key.getKey(new int[]{input});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        @Override
        public boolean enableAlternateBuffer() {
            return false;
        }

        @Override
        public boolean enableMainBuffer() {
            return false;
        }

        @Override
        public Size size() {
            return new Size(1, -1);
        }

        @Override
        public void clear() {
            Console console = System.console();
            if (console != null) {
                console.writer().write(Parser.fromCodePoints(ANSI.CLEAR_SCREEN));
            }
        }
    }
}

