/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.map.MapCommand;
import org.aesh.command.map.MapProcessedOptionProvider;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidator;
import org.aesh.readline.util.Parser;

public class MapProcessedCommand<CI extends CommandInvocation>
extends ProcessedCommand<MapCommand<CI>, CI> {
    private final MapProcessedOptionProvider provider;
    private List<ProcessedOption> currentOptions;
    private final boolean initialized;
    private final boolean lookup;
    private CommandLineParser.Mode mode;
    private static final MapProcessedOptionProvider EMPTY_PROVIDER = options -> Collections.emptyList();

    MapProcessedCommand(String name, List<String> aliases, MapCommand<CI> command, String description, CommandValidator<MapCommand<CI>, CI> validator, ResultHandler resultHandler, boolean generateHelp, boolean disableParsing, String version, ProcessedOption arguments, List<ProcessedOption> options, ProcessedOption argument, CommandPopulator<Object, CI> populator, MapProcessedOptionProvider provider, CommandActivator activator, boolean lookup) throws OptionParserException {
        super(name, aliases, command, description, validator, resultHandler, generateHelp, disableParsing, version, arguments, options, argument, populator, activator);
        this.initialized = true;
        this.provider = provider == null ? EMPTY_PROVIDER : provider;
        this.lookup = lookup;
    }

    @Override
    protected void updateOptionsInvocationProviders(InvocationProviders invocationProviders) {
        for (ProcessedOption option : super.getOptions()) {
            option.updateInvocationProviders(invocationProviders);
        }
    }

    @Override
    public List<ProcessedOption> getOptions() {
        if (!this.initialized) {
            return super.getOptions();
        }
        return this.getOptions(true);
    }

    @Override
    public boolean hasAskIfNotSet() {
        for (ProcessedOption opt : this.getOptions(false)) {
            if (!opt.askIfNotSet() || !opt.hasValue() || !opt.getValues().isEmpty() || opt.hasDefaultValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ProcessedOption searchAllOptions(String input) {
        if (!this.initialized) {
            return super.searchAllOptions(input);
        }
        if (this.lookup && !CommandLineParser.Mode.COMPLETION.equals((Object)this.mode)) {
            return null;
        }
        if (input.startsWith("--")) {
            ProcessedOption currentOption = this.findLongOptionNoActivatorCheck(input.substring(2));
            if (currentOption == null && input.contains("=")) {
                currentOption = this.startWithLongOptionNoActivatorCheck(input.substring(2));
            }
            if (currentOption != null) {
                currentOption.setLongNameUsed(true);
            } else if (Parser.containsNonEscapedSpace(input)) {
                return this.searchAllOptions(Parser.switchSpacesToEscapedSpacesInWord(input));
            }
            return currentOption;
        }
        return super.searchAllOptions(input);
    }

    @Override
    public ProcessedOption findLongOption(String name) {
        if (!this.initialized) {
            return super.findLongOption(name);
        }
        if (this.lookup && !CommandLineParser.Mode.COMPLETION.equals((Object)this.mode)) {
            return null;
        }
        for (ProcessedOption option : this.getOptions(false)) {
            if (option.name() == null || !option.name().equals(name) || !option.activator().isActivated(new ParsedCommand(this))) continue;
            return option;
        }
        for (ProcessedOption option : this.getOptions(true)) {
            if (option.name() == null || !option.name().equals(name) || !option.activator().isActivated(new ParsedCommand(this))) continue;
            return option;
        }
        return null;
    }

    @Override
    public ProcessedOption findLongOptionNoActivatorCheck(String name) {
        if (!this.initialized) {
            return super.findLongOptionNoActivatorCheck(name);
        }
        if (this.lookup && !CommandLineParser.Mode.COMPLETION.equals((Object)this.mode)) {
            return null;
        }
        for (ProcessedOption option : this.getOptions(false)) {
            if (option.name() == null || !option.name().equals(name)) continue;
            return option;
        }
        for (ProcessedOption option : this.getOptions(true)) {
            if (option.name() == null || !option.name().equals(name)) continue;
            return option;
        }
        return null;
    }

    @Override
    public void clearOptions() {
        for (ProcessedOption processedOption : this.getCurrentOptions()) {
            processedOption.clear();
        }
    }

    List<ProcessedOption> getCurrentOptions() {
        ArrayList<ProcessedOption> allOptions = new ArrayList<ProcessedOption>(super.getOptions());
        if (this.currentOptions != null) {
            allOptions.addAll(this.currentOptions);
        }
        return allOptions;
    }

    public List<ProcessedOption> getOptions(boolean dynamic) {
        ArrayList<ProcessedOption> allOptions = new ArrayList<ProcessedOption>(super.getOptions());
        if (this.provider != null && dynamic) {
            if (this.currentOptions == null || this.currentOptions.isEmpty()) {
                this.currentOptions = this.provider.getOptions(this.currentOptions);
            }
            allOptions.addAll(this.currentOptions);
        }
        return allOptions;
    }

    @Override
    public void clear() {
        MapCommand cmd = (MapCommand)this.getCommand();
        this.mode = null;
        cmd.resetAll();
        super.clear();
        this.currentOptions = null;
    }

    public void setMode(CommandLineParser.Mode mode) {
        this.mode = mode;
    }
}

