/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.impl;

import java.io.IOException;
import java.util.logging.Level;
import org.aesh.readline.terminal.impl.AbstractWindowsTerminal;
import org.aesh.readline.terminal.impl.SignalHandlers;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Size;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.internal.Kernel32;

public class WinSysTerminal
extends AbstractWindowsTerminal {
    private static final int VIRTUAL_TERMINAL_PROCESSING = 4;

    public WinSysTerminal(String name, boolean nativeSignals) throws IOException {
        this(name, nativeSignals, SignalHandlers.SIG_DFL);
    }

    public WinSysTerminal(String name, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        super(WinSysTerminal.setVTMode(), AnsiConsole.out(), name, nativeSignals, signalHandler);
    }

    @Override
    protected int getConsoleOutputCP() {
        return Kernel32.GetConsoleOutputCP();
    }

    @Override
    protected int getConsoleMode() {
        long hConsole = Kernel32.GetStdHandle(Kernel32.STD_INPUT_HANDLE);
        if (hConsole == (long)Kernel32.INVALID_HANDLE_VALUE) {
            return -1;
        }
        int[] mode = new int[1];
        return Kernel32.GetConsoleMode(hConsole, mode) == 0 ? -1 : mode[0];
    }

    @Override
    protected void setConsoleMode(int mode) {
        long hConsole = Kernel32.GetStdHandle(Kernel32.STD_INPUT_HANDLE);
        if (hConsole != (long)Kernel32.INVALID_HANDLE_VALUE) {
            Kernel32.SetConsoleMode(hConsole, mode);
        }
    }

    @Override
    public Size getSize() {
        long outputHandle = Kernel32.GetStdHandle(Kernel32.STD_OUTPUT_HANDLE);
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.GetConsoleScreenBufferInfo(outputHandle, info);
        Size size = new Size(info.windowWidth(), info.windowHeight());
        return size;
    }

    @Override
    protected byte[] readConsoleInput() {
        Kernel32.INPUT_RECORD[] events = null;
        long hConsole = Kernel32.GetStdHandle(Kernel32.STD_INPUT_HANDLE);
        try {
            events = hConsole == (long)Kernel32.INVALID_HANDLE_VALUE ? null : Kernel32.readConsoleInputHelper(hConsole, 1, false);
        }
        catch (IOException e) {
            this.LOGGER.log(Level.INFO, "read Windows terminal input error: ", e);
        }
        if (events == null) {
            return new byte[0];
        }
        StringBuilder sb = new StringBuilder();
        for (Kernel32.INPUT_RECORD event : events) {
            boolean isAlt;
            Kernel32.KEY_EVENT_RECORD keyEvent = event.keyEvent;
            int altState = Kernel32.KEY_EVENT_RECORD.LEFT_ALT_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_ALT_PRESSED;
            int ctrlState = Kernel32.KEY_EVENT_RECORD.LEFT_CTRL_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_CTRL_PRESSED;
            boolean bl = isAlt = (keyEvent.controlKeyState & altState) != 0 && (keyEvent.controlKeyState & ctrlState) == 0;
            if (keyEvent.keyDown) {
                if (keyEvent.uchar > '\u0000') {
                    boolean shiftPressed;
                    boolean bl2 = shiftPressed = (keyEvent.controlKeyState & Kernel32.KEY_EVENT_RECORD.SHIFT_PRESSED) != 0;
                    if (keyEvent.uchar == '\t' && shiftPressed) {
                        sb.append(this.getSequence(Capability.key_btab));
                        continue;
                    }
                    if (isAlt) {
                        sb.append('\u001b');
                    }
                    sb.append(keyEvent.uchar);
                    continue;
                }
                String escapeSequence = this.getEscapeSequence(keyEvent.keyCode);
                if (escapeSequence == null) continue;
                for (int k = 0; k < keyEvent.repeatCount; ++k) {
                    if (isAlt) {
                        sb.append('\u001b');
                    }
                    sb.append(escapeSequence);
                }
                continue;
            }
            if (keyEvent.keyCode != 18 || keyEvent.uchar <= '\u0000') continue;
            sb.append(keyEvent.uchar);
        }
        return sb.toString().getBytes();
    }

    private static boolean setVTMode() {
        int[] mode;
        long console = Kernel32.GetStdHandle(Kernel32.STD_OUTPUT_HANDLE);
        if (Kernel32.GetConsoleMode(console, mode = new int[1]) == 0) {
            return false;
        }
        return Kernel32.SetConsoleMode(console, mode[0] | 4) != 0;
    }

    public static boolean isVTSupported() {
        return WinSysTerminal.setVTMode();
    }
}

