/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aesh.command.shell.Shell;
import org.aesh.readline.terminal.Key;
import org.aesh.selector.SelectLine;
import org.aesh.terminal.utils.ANSI;
import org.aesh.terminal.utils.Config;

public class MultiSelect {
    private final Shell shell;
    private boolean pagination;
    private final String message;
    private int maxDisplayedLines = 0;
    private List<SelectLine> lines;
    private Page page;
    private int focusLine = 0;

    public MultiSelect(Shell shell, List<String> defaultValues, String message) {
        this(shell, message);
        this.lines = new ArrayList<SelectLine>(defaultValues.size());
        for (String value : defaultValues) {
            this.lines.add(new SelectLine(value, shell.size().getWidth()));
        }
        this.pagination = this.lines.size() + 1 > shell.size().getHeight();
    }

    public MultiSelect(Shell shell, String message) {
        this.shell = shell;
        this.message = message;
        this.maxDisplayedLines = shell.size().getHeight() - 1;
    }

    public void setLines(List<SelectLine> lines) {
        this.lines = new ArrayList<SelectLine>(lines.size());
        this.lines.addAll(lines);
        this.pagination = lines.size() + 1 > this.shell.size().getHeight();
    }

    public List<String> doSelect() {
        this.shell.write("\u001b[?25l");
        if (this.pagination) {
            this.shell.write(ANSI.ALTERNATE_BUFFER);
        }
        this.lines.get(this.focusLine).focus();
        this.page = new Page(this.focusLine, this.calcNumOfDisplayableLines());
        this.displayPage(this.page.top(), this.page.bottom(), this.focusLine);
        boolean waitingForEnter = true;
        while (waitingForEnter) {
            try {
                Key in = this.shell.read();
                if (in == Key.ENTER || in == Key.ENTER_2 || in == Key.CTRL_M) {
                    waitingForEnter = false;
                    if (!this.pagination) {
                        this.shell.write(ANSI.moveRowsDown(this.page.bottom() - this.focusLine));
                    }
                    this.shell.write("\u001b[?25h");
                    continue;
                }
                if (in == Key.SPACE) {
                    this.lines.get(this.focusLine).select();
                    this.shell.write(this.lines.get(this.focusLine).print());
                    this.shell.write(ANSI.CURSOR_START);
                    continue;
                }
                if (in == Key.UP || in == Key.UP_2) {
                    if (this.focusLine > this.page.top()) {
                        this.moveUp();
                        continue;
                    }
                    if (this.page.top() <= 0) continue;
                    this.page = new Page(this.page.top - 1, this.page.bottom() - 1);
                    this.displayPage(this.page.top(), this.maxDisplayedLines, this.focusLine);
                    this.moveUp();
                    continue;
                }
                if (in == Key.PGUP || in == Key.PGUP_2) {
                    if (this.page.top() == 0) {
                        if (this.focusLine <= this.page.top()) continue;
                        this.moveUp(this.focusLine);
                        continue;
                    }
                    if (this.page.top() - this.maxDisplayedLines < 0) {
                        int diffUp = this.page.top();
                        if (diffUp <= 0) continue;
                        this.page = new Page(this.page.top - diffUp, this.page.bottom() - diffUp);
                        this.updateFocusLineGoingUp();
                        continue;
                    }
                    if (this.page.top() - this.maxDisplayedLines < 0) continue;
                    this.page = new Page(this.page.top - this.maxDisplayedLines, this.page.bottom() - this.maxDisplayedLines);
                    this.updateFocusLineGoingUp();
                    continue;
                }
                if (in == Key.DOWN || in == Key.DOWN_2) {
                    if (this.focusLine < this.page.bottom() - 1) {
                        this.moveDown();
                        continue;
                    }
                    if (this.page.bottom() >= this.lines.size()) continue;
                    this.page = new Page(this.page.top + 1, this.page.bottom() + 1);
                    this.displayPage(this.page.top(), this.maxDisplayedLines, this.focusLine);
                    this.moveDown();
                    continue;
                }
                if (in != Key.PGDOWN && in != Key.PGDOWN_2) continue;
                if (this.page.bottom() == this.lines.size()) {
                    if (this.focusLine >= this.page.bottom() - 1) continue;
                    this.moveDown(this.page.bottom() - this.focusLine - 1);
                    continue;
                }
                if (this.page.bottom() + this.maxDisplayedLines > this.lines.size()) {
                    int diffDown = this.lines.size() - this.page.bottom();
                    if (diffDown <= 0) continue;
                    this.page = new Page(this.page.top + diffDown, this.page.bottom() + diffDown);
                    this.updateFocusLineGoingDown();
                    continue;
                }
                this.page = new Page(this.page.top + this.maxDisplayedLines, this.page.bottom() + this.maxDisplayedLines);
                this.updateFocusLineGoingDown();
            }
            catch (InterruptedException e) {
                if (!this.pagination) {
                    this.shell.write(ANSI.moveRowsDown(this.page.bottom() - this.focusLine));
                }
                this.shell.write("\u001b[?25h");
            }
        }
        if (this.pagination) {
            this.shell.write(ANSI.MAIN_BUFFER);
        }
        this.shell.write("\u001b[?25h");
        return this.collectSelected();
    }

    private void updateFocusLineGoingDown() {
        this.lines.get(this.focusLine).focus();
        this.focusLine += this.maxDisplayedLines;
        if (this.focusLine > this.lines.size() - 1) {
            this.focusLine = this.lines.size() - 1;
        }
        this.lines.get(this.focusLine).focus();
        this.displayPage(this.page.top(), this.maxDisplayedLines, this.focusLine);
    }

    private void updateFocusLineGoingUp() {
        this.lines.get(this.focusLine).focus();
        this.focusLine -= this.maxDisplayedLines;
        if (this.focusLine < 0) {
            this.focusLine = 0;
        }
        this.lines.get(this.focusLine).focus();
        this.displayPage(this.page.top(), this.maxDisplayedLines, this.focusLine);
    }

    private void moveDown(int move) {
        this.lines.get(this.focusLine).focus();
        this.focusLine += move;
        this.lines.get(this.focusLine).focus();
        this.shell.write(' ');
        this.shell.write(ANSI.moveRowsDown(move));
        this.shell.write(ANSI.CURSOR_START);
        this.shell.write('>');
        this.shell.write(ANSI.CURSOR_START);
    }

    private void moveDown() {
        this.lines.get(this.focusLine).focus();
        ++this.focusLine;
        this.lines.get(this.focusLine).focus();
        this.shell.write(' ');
        this.shell.write(ANSI.MOVE_LINE_DOWN);
        this.shell.write(ANSI.CURSOR_START);
        this.shell.write('>');
        this.shell.write(ANSI.CURSOR_START);
    }

    private void moveUp() {
        this.lines.get(this.focusLine).focus();
        --this.focusLine;
        this.lines.get(this.focusLine).focus();
        this.shell.write(' ');
        this.shell.write(ANSI.MOVE_LINE_UP);
        this.shell.write(ANSI.CURSOR_START);
        this.shell.write('>');
        this.shell.write(ANSI.CURSOR_START);
    }

    private void moveUp(int move) {
        this.lines.get(this.focusLine).focus();
        this.focusLine -= move;
        this.lines.get(this.focusLine).focus();
        this.shell.write(' ');
        this.shell.write(ANSI.moveRowsUp(move));
        this.shell.write(ANSI.CURSOR_START);
        this.shell.write('>');
        this.shell.write(ANSI.CURSOR_START);
    }

    private int calcNumOfDisplayableLines() {
        if (this.maxDisplayedLines < this.lines.size()) {
            return this.maxDisplayedLines;
        }
        return this.lines.size();
    }

    private void displayPage(int startLine, int numberOfLines, int focusLine) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.message + "  [Use arrow up/down to move and space to select. Enter to finish]");
        for (int i = startLine; i < startLine + numberOfLines; ++i) {
            builder.append(Config.getLineSeparator());
            builder.append(this.lines.get(i).print());
        }
        if (this.pagination) {
            this.shell.write(ANSI.CLEAR_SCREEN);
        }
        this.shell.write(builder.toString());
        this.shell.write(ANSI.CURSOR_START);
        if (focusLine < startLine + numberOfLines - 1) {
            this.shell.write(ANSI.moveRowsUp(startLine + numberOfLines - focusLine - 1));
        }
    }

    private List<String> collectSelected() {
        return this.lines.stream().filter(SelectLine::isSelected).map(SelectLine::value).collect(Collectors.toList());
    }

    class Page {
        private int top;
        private int bottom;

        Page(int top, int bottom) {
            this.top = top;
            this.bottom = bottom;
        }

        public int top() {
            return this.top;
        }

        public void setTop(int top) {
            this.top = top;
        }

        public int bottom() {
            return this.bottom;
        }

        public void setBottom(int bottom) {
            this.bottom = bottom;
        }

        public String toString() {
            return "Page{top=" + this.top + ", bottom=" + this.bottom + '}';
        }
    }
}

