/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainer;
import org.aesh.command.impl.container.AeshCommandContainerBuilder;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedCommandBuilder;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.impl.parser.CommandLineParserBuilder;
import org.aesh.command.impl.registry.MutableCommandRegistryImpl;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.registry.MutableCommandRegistry;
import org.aesh.parser.ParsedLine;
import org.aesh.readline.completion.CompleteOperation;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.impl.CommandContextImpl;
import org.jboss.as.cli.impl.aesh.CLICommandContainer;
import org.jboss.as.cli.impl.aesh.ExpressionValueConverter;
import org.jboss.as.cli.impl.aesh.cmd.operation.LegacyCommandContainer;
import org.jboss.as.cli.impl.aesh.cmd.operation.OperationCommandContainer;
import org.jboss.logging.Logger;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

public class CLICommandRegistry
extends CommandRegistry
implements org.aesh.command.registry.CommandRegistry {
    private static final Logger log = Logger.getLogger(CLICommandRegistry.class);
    private final MutableCommandRegistry reg = new MutableCommandRegistryImpl();
    private final AeshCommandContainerBuilder<? extends CommandInvocation> containerBuilder = new AeshCommandContainerBuilder();
    private final CommandContextImpl ctx;
    private final OperationCommandContainer op;

    public CLICommandRegistry(CommandContextImpl ctx, OperationCommandContainer op) {
        this.ctx = ctx;
        this.op = op;
    }

    @Override
    public CommandHandler remove(String cmdName) {
        this.removeCommand(cmdName);
        return super.remove(cmdName);
    }

    private CommandContainer addCommandContainer(CommandContainer container, boolean checkExistence) throws CommandLineException {
        CLICommandContainer cliContainer;
        try {
            cliContainer = container instanceof CLICommandContainer ? (CLICommandContainer)container : this.wrapContainer(container);
        }
        catch (OptionParserException ex) {
            throw new CommandLineException(ex);
        }
        if (checkExistence) {
            this.checkExistence(container.getParser().getProcessedCommand().name());
        }
        this.reg.addCommand(cliContainer);
        return cliContainer;
    }

    @Override
    public void registerHandler(CommandHandler handler, boolean tabComplete, String ... names) throws CommandRegistry.RegisterHandlerException {
        CommandRegistry.RegisterHandlerException error = null;
        for (String name : names) {
            try {
                this.checkExistence(name);
            }
            catch (CommandLineException ex) {
                if (error == null) {
                    error = new CommandRegistry.RegisterHandlerException(name);
                    continue;
                }
                error.addCommand(name);
            }
        }
        if (error != null) {
            throw error;
        }
        super.registerHandler(handler, tabComplete, names);
        if (tabComplete) {
            try {
                this.addCommandContainer(new LegacyCommandContainer(this.ctx, names, handler), false);
            }
            catch (CommandLineParserException | CommandLineException ex) {
                throw new CommandRegistry.RegisterHandlerException(ex.getLocalizedMessage());
            }
        }
    }

    private void checkExistence(String name) throws CommandRegistry.RegisterHandlerException {
        try {
            this.reg.getCommand(name, name);
            throw new CommandRegistry.RegisterHandlerException(name);
        }
        catch (CommandNotFoundException ex) {
            if (this.getCommandHandler(name) != null) {
                throw new CommandRegistry.RegisterHandlerException(name);
            }
            return;
        }
    }

    CLICommandContainer wrapContainer(CommandContainer commandContainer) throws OptionParserException {
        return new CLICommandContainer(commandContainer, this.ctx);
    }

    public CommandContainer addCommand(Command<?> command) throws CommandLineException, CommandLineParserException {
        return this.addCommand(command, Collections.emptyMap(), false);
    }

    public CommandContainer addThirdPartyCommand(Command<?> command, Map<String, String> renaming) throws CommandLineParserException, CommandLineException {
        return this.addCommand(command, renaming, true);
    }

    public CommandContainer addCommand(Command<? extends CommandInvocation> command, Map<String, String> renaming, boolean thirdparty) throws CommandLineException, CommandLineParserException {
        String rename;
        AeshCommandContainer<CommandInvocation> container = this.containerBuilder.create(command);
        String name = container.getParser().getProcessedCommand().name();
        int index = name.indexOf("@");
        if (index >= 0 && index != name.length() - 1) {
            String parentName = name.substring(index + 1);
            String childName = name.substring(0, index);
            if (!parentName.isEmpty()) {
                try {
                    CommandLineParser existingParent = this.findCommand(parentName, parentName);
                    try {
                        this.findCommand(parentName, parentName + " " + childName);
                        throw new CommandLineException("Command " + parentName + " " + childName + " already exists. Can't register " + name);
                    }
                    catch (CommandNotFoundException commandNotFoundException) {
                        try {
                            CommandLineParser parser = container.getParser();
                            ProcessedCommand cmd = parser.getProcessedCommand();
                            ProcessedCommandBuilder cmdBuilder = ProcessedCommandBuilder.builder();
                            ProcessedCommand cmd2 = cmdBuilder.activator(cmd.getActivator()).addOptions(cmd.getOptions()).aliases(cmd.getAliases()).arguments(cmd.getArguments()).argument(cmd.getArgument()).command(cmd.getCommand()).description(cmd.description()).name(childName).populator(cmd.getCommandPopulator()).resultHandler(cmd.resultHandler()).validator(cmd.validator()).create();
                            container = new AeshCommandContainer(cmd2);
                            existingParent.addChildParser(container.getParser());
                        }
                        catch (CommandLineParserException ex) {
                            throw new CommandLineException(ex);
                        }
                        return this.getCommand(parentName, parentName + " " + childName);
                    }
                }
                catch (CommandNotFoundException ex) {
                    log.warn("No parent " + parentName + " command found. Registering command as " + name);
                }
            }
        }
        if ((rename = renaming.get(name)) != null) {
            ProcessedCommand<Command<? extends CommandInvocation>, ? extends CommandInvocation> cmd = container.getParser().getProcessedCommand();
            ProcessedCommandBuilder cmdBuilder = ProcessedCommandBuilder.builder();
            container = new AeshCommandContainer<CommandInvocation>(CommandLineParserBuilder.builder().processedCommand(cmdBuilder.activator(cmd.getActivator()).addOptions(cmd.getOptions()).aliases(cmd.getAliases()).arguments(cmd.getArguments()).argument(cmd.getArgument()).command(cmd.getCommand()).description(cmd.description()).name(rename).populator(cmd.getCommandPopulator()).resultHandler(cmd.resultHandler()).validator(cmd.validator()).create()).create());
        }
        if (thirdparty) {
            AeshCommandContainer<? extends CommandInvocation> convertedContainer = this.disableResolution(container.getParser());
            Iterator<CommandLineParser<? extends CommandInvocation>> iterator = container.getParser().getAllChildParsers().iterator();
            while (iterator.hasNext()) {
                CommandLineParser<? extends CommandInvocation> obj;
                CommandLineParser<? extends CommandInvocation> cp = obj = iterator.next();
                convertedContainer.getParser().addChildParser(this.disableResolution(cp).getParser());
            }
            container = convertedContainer;
        }
        return this.addCommand(container);
    }

    private CommandContainer disableResolution(CommandLineParser parser) throws OptionParserException, CommandLineParserException {
        ProcessedCommand cmd = parser.getProcessedCommand();
        ProcessedCommandBuilder cmdBuilder = ProcessedCommandBuilder.builder();
        AeshCommandContainer convertedContainer = new AeshCommandContainer(CommandLineParserBuilder.builder().processedCommand(cmdBuilder.activator(cmd.getActivator()).addOptions(ExpressionValueConverter.disableResolution(cmd.getOptions())).aliases(cmd.getAliases()).arguments(ExpressionValueConverter.disableResolution(cmd.getArguments())).argument(ExpressionValueConverter.disableResolution(cmd.getArgument())).command(cmd.getCommand()).description(cmd.description()).name(cmd.name()).populator(cmd.getCommandPopulator()).resultHandler(cmd.resultHandler()).validator(cmd.validator()).create()).create());
        return convertedContainer;
    }

    public CommandContainer addCommand(CommandContainer container) throws CommandLineException {
        return this.addCommandContainer(container, true);
    }

    public CommandContainer<CLICommandInvocation> getCommand(String name, String line) throws CommandNotFoundException {
        if (OperationCommandContainer.isOperation(name)) {
            return this.op;
        }
        return this.reg.getCommand(name, line);
    }

    @Override
    public void completeCommandName(CompleteOperation completeOperation, ParsedLine parsedLine) {
        this.reg.completeCommandName(completeOperation, parsedLine);
    }

    @Override
    public Set<String> getAllCommandNames() {
        return this.reg.getAllCommandNames();
    }

    public void removeCommand(String name) {
        this.reg.removeCommand(name);
    }

    public CommandLineParser findCommand(String name, String line) throws CommandNotFoundException {
        String[] split;
        CommandContainer<CLICommandInvocation> c = this.getCommand(name, line);
        CommandLineParser<CLICommandInvocation> p = c.getParser();
        String[] stringArray = split = line == null ? new String[]{} : line.split(" ");
        if (split.length > 1) {
            String sub = split[1];
            CommandLineParser<CLICommandInvocation> child = c.getParser().getChildParser(sub);
            if (child != null) {
                if (c instanceof CLICommandContainer) {
                    CLICommandContainer cli = (CLICommandContainer)c;
                    child = cli.wrapParser(child);
                }
                p = child;
            } else {
                throw new CommandNotFoundException("Command not found " + line, name);
            }
        }
        return p;
    }

    public CommandContainer getCommandByAlias(String alias) throws CommandNotFoundException {
        return this.reg.getCommandByAlias(alias);
    }

    public List<CommandLineParser<?>> getChildCommandParsers(String parent) throws CommandNotFoundException {
        return this.reg.getChildCommandParsers(parent);
    }

    @Override
    public void addRegistrationListener(CommandRegistry.CommandRegistrationListener listener) {
        this.reg.addRegistrationListener(listener);
    }

    @Override
    public void removeRegistrationListener(CommandRegistry.CommandRegistrationListener listener) {
        this.reg.removeRegistrationListener(listener);
    }

    public String getCommandName(Command<CLICommandInvocation> command) throws CommandLineParserException {
        CommandContainer<? extends CommandInvocation> container = this.containerBuilder.create(command);
        return container.getParser().getProcessedCommand().name();
    }

    public List<String> getAvailableAeshCommands() {
        ArrayList<String> lst = new ArrayList<String>();
        for (String c : this.getAllCommandNames()) {
            CommandLineParser cmdParser;
            try {
                cmdParser = this.findCommand(c, null);
            }
            catch (CommandNotFoundException ex) {
                continue;
            }
            CommandActivator activator = cmdParser.getProcessedCommand().getActivator();
            if (activator != null && !activator.isActivated(new ParsedCommand(cmdParser.getProcessedCommand()))) continue;
            lst.add(c);
        }
        return lst;
    }

    public boolean isLegacyCommand(String name) {
        try {
            CLICommandContainer c = (CLICommandContainer)this.getCommand(name, name);
            return c.getWrappedContainer() instanceof LegacyCommandContainer;
        }
        catch (CommandNotFoundException ex) {
            return false;
        }
    }
}

