/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.configuration;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.configuration.ConfigurationResource;

public class ContextConfiguration
implements AutoCloseable {
    public static final Logger.AttachmentKey<ContextConfiguration> CONTEXT_CONFIGURATION_KEY = new Logger.AttachmentKey();
    private final LogContext context;
    private final Map<String, ConfigurationResource<ErrorManager>> errorManagers;
    private final Map<String, ConfigurationResource<Filter>> filters;
    private final Map<String, ConfigurationResource<Formatter>> formatters;
    private final Map<String, ConfigurationResource<Handler>> handlers;
    private final Map<String, ConfigurationResource<Object>> objects;

    public ContextConfiguration(LogContext context) {
        this.context = context;
        this.errorManagers = new ConcurrentHashMap<String, ConfigurationResource<ErrorManager>>();
        this.handlers = new ConcurrentHashMap<String, ConfigurationResource<Handler>>();
        this.formatters = new ConcurrentHashMap<String, ConfigurationResource<Formatter>>();
        this.filters = new ConcurrentHashMap<String, ConfigurationResource<Filter>>();
        this.objects = new ConcurrentHashMap<String, ConfigurationResource<Object>>();
    }

    public LogContext getContext() {
        return this.context;
    }

    public boolean hasLogger(String name) {
        return this.getContext().getLoggerIfExists(Objects.requireNonNull(name, "The name cannot be null")) != null;
    }

    public Logger getLogger(String name) {
        return this.getContext().getLogger(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Set<String> getLoggers() {
        return Set.copyOf(Collections.list(this.getContext().getLoggerNames()));
    }

    public ConfigurationResource<ErrorManager> addErrorManager(String name, Supplier<ErrorManager> errorManager) {
        if (errorManager == null) {
            return this.removeErrorManager(name);
        }
        return this.errorManagers.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), ConfigurationResource.of(errorManager));
    }

    public ConfigurationResource<ErrorManager> removeErrorManager(String name) {
        return this.errorManagers.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasErrorManager(String name) {
        return this.errorManagers.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public ErrorManager getErrorManager(String name) {
        if (this.errorManagers.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return (ErrorManager)this.errorManagers.get(name).get();
        }
        return null;
    }

    public Map<String, ConfigurationResource<ErrorManager>> getErrorManagers() {
        return Collections.unmodifiableMap(this.errorManagers);
    }

    public ConfigurationResource<Handler> addHandler(String name, Supplier<Handler> handler) {
        if (handler == null) {
            return this.removeHandler(name);
        }
        return this.handlers.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), ConfigurationResource.of(handler));
    }

    public ConfigurationResource<Handler> removeHandler(String name) {
        return this.handlers.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasHandler(String name) {
        return this.handlers.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Handler getHandler(String name) {
        if (this.handlers.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return (Handler)this.handlers.get(name).get();
        }
        return null;
    }

    public Map<String, ConfigurationResource<Handler>> getHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    public ConfigurationResource<Formatter> addFormatter(String name, Supplier<Formatter> formatter) {
        if (formatter == null) {
            return this.removeFormatter(name);
        }
        return this.formatters.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), ConfigurationResource.of(formatter));
    }

    public ConfigurationResource<Formatter> removeFormatter(String name) {
        return this.formatters.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasFormatter(String name) {
        return this.formatters.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Formatter getFormatter(String name) {
        if (this.formatters.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return (Formatter)this.formatters.get(name).get();
        }
        return null;
    }

    public Map<String, Supplier<Formatter>> getFormatters() {
        return Collections.unmodifiableMap(this.formatters);
    }

    public ConfigurationResource<Filter> addFilter(String name, Supplier<Filter> filter) {
        if (filter == null) {
            return this.removeFilter(name);
        }
        return this.filters.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), ConfigurationResource.of(filter));
    }

    public ConfigurationResource<Filter> removeFilter(String name) {
        return this.filters.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasFilter(String name) {
        return this.filters.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Filter getFilter(String name) {
        if (this.filters.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return (Filter)this.filters.get(name).get();
        }
        return null;
    }

    public Map<String, ConfigurationResource<Filter>> getFilters() {
        return Collections.unmodifiableMap(this.filters);
    }

    public ConfigurationResource<Object> addObject(String name, Supplier<Object> object) {
        if (object == null) {
            return this.removeObject(name);
        }
        return this.objects.putIfAbsent(Objects.requireNonNull(name, "The name cannot be null"), ConfigurationResource.of(object));
    }

    public ConfigurationResource<Object> removeObject(String name) {
        return this.objects.remove(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public boolean hasObject(String name) {
        return this.objects.containsKey(Objects.requireNonNull(name, "The name cannot be null"));
    }

    public Object getObject(String name) {
        if (this.objects.containsKey(Objects.requireNonNull(name, "The name cannot be null"))) {
            return this.objects.get(name).get();
        }
        return null;
    }

    public Map<String, ConfigurationResource<Object>> getObjects() {
        return Collections.unmodifiableMap(this.objects);
    }

    @Override
    public void close() throws Exception {
        this.context.close();
        ContextConfiguration.closeResources(this.handlers);
        ContextConfiguration.closeResources(this.filters);
        ContextConfiguration.closeResources(this.formatters);
        ContextConfiguration.closeResources(this.errorManagers);
        ContextConfiguration.closeResources(this.objects);
    }

    private static void closeResources(Map<String, ? extends ConfigurationResource<?>> resources) {
        Iterator<Map.Entry<String, ConfigurationResource<?>>> iter2 = resources.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry<String, ConfigurationResource<?>> entry = iter2.next();
            iter2.remove();
            try {
                entry.getValue().close();
            }
            catch (Throwable throwable) {}
        }
    }
}

