/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.Iterator;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public final class AllFilter
implements Filter {
    private final Filter[] filters;

    public AllFilter(Filter[] filters) {
        this.filters = (Filter[])filters.clone();
    }

    public AllFilter(Iterable<Filter> filters) {
        this(filters.iterator());
    }

    public AllFilter(Iterator<Filter> filters) {
        this.filters = AllFilter.unroll(filters, 0);
    }

    private static Filter[] unroll(Iterator<Filter> iter2, int cnt) {
        if (iter2.hasNext()) {
            Filter filter = iter2.next();
            if (filter == null) {
                throw new NullPointerException("filter at index " + cnt + " is null");
            }
            Filter[] filters = AllFilter.unroll(iter2, cnt + 1);
            filters[cnt] = filter;
            return filters;
        }
        return new Filter[cnt];
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        for (Filter filter : this.filters) {
            if (filter.isLoggable(record)) continue;
            return false;
        }
        return true;
    }
}

