/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import java.util.ArrayList;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;

public class ClientCaptureCurrentContextRestHandler
implements ClientRestHandler {
    private static final String RESTEASY_REACTIVE_PACKAGE = "org.jboss.resteasy.reactive";
    private static final String AUTOGENERATED_TAG = "$$";
    private static final StackTraceElement[] EMPTY_ARRAY = new StackTraceElement[0];
    private final boolean captureStacktrace;

    public ClientCaptureCurrentContextRestHandler(boolean captureStacktrace) {
        this.captureStacktrace = captureStacktrace;
    }

    @Override
    public void handle(RestClientRequestContext requestContext) throws Exception {
        ClientRequestContextImpl clientRequestContext = requestContext.getClientRequestContext();
        if (clientRequestContext == null) {
            return;
        }
        if (this.captureStacktrace) {
            this.captureCallerStackTrace(clientRequestContext);
        }
    }

    private void captureCallerStackTrace(ClientRequestContextImpl clientRequestContext) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        ArrayList<StackTraceElement> effectiveStackTrace = new ArrayList<StackTraceElement>(stackTrace.length);
        boolean foundUserMethod = false;
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement trace = stackTrace[i];
            if (foundUserMethod) {
                effectiveStackTrace.add(trace);
                continue;
            }
            if (trace.getClassName().startsWith(RESTEASY_REACTIVE_PACKAGE) || trace.getClassName().contains(AUTOGENERATED_TAG)) continue;
            effectiveStackTrace.add(trace);
            foundUserMethod = true;
        }
        clientRequestContext.getRestClientRequestContext().setCallerStackTrace(effectiveStackTrace.toArray(EMPTY_ARRAY));
    }
}

