/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.InterceptorContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractClientInterceptorContextImpl
implements InterceptorContext {
    protected MediaType mediaType;
    protected Type entityType;
    protected Class<?> entityClass;
    protected Annotation[] annotations;
    protected Map<String, Object> properties;

    public AbstractClientInterceptorContextImpl(Annotation[] annotations, Class<?> entityClass, Type entityType, MediaType mediaType, Map<String, Object> properties) {
        this.annotations = annotations;
        this.entityClass = entityClass;
        this.entityType = entityType;
        this.mediaType = mediaType;
        this.properties = properties;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public void setProperty(String name, Object object) {
        this.properties.put(name, object);
    }

    @Override
    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotations) {
        Objects.requireNonNull(annotations);
        this.annotations = annotations;
    }

    @Override
    public Class<?> getType() {
        return this.entityClass;
    }

    @Override
    public void setType(Class<?> type) {
        this.entityClass = type;
    }

    @Override
    public Type getGenericType() {
        return this.entityType;
    }

    @Override
    public void setGenericType(Type genericType) {
        this.entityType = genericType;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }
}

