/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.netty.channel.EventLoopGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Timer;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientBuilder;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.spi.VerticleFactory;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;
import org.jboss.resteasy.reactive.client.handlers.AdvancedRedirectHandler;
import org.jboss.resteasy.reactive.client.handlers.RedirectHandler;
import org.jboss.resteasy.reactive.client.impl.HandlerChain;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.client.impl.WrapperVertxAdvancedRedirectHandlerImpl;
import org.jboss.resteasy.reactive.client.impl.WrapperVertxRedirectHandlerImpl;
import org.jboss.resteasy.reactive.client.spi.ClientContext;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.jaxrs.MultiQueryParamMode;
import org.jboss.resteasy.reactive.common.jaxrs.UriBuilderImpl;

public class ClientImpl
implements Client {
    private static final Logger log = Logger.getLogger(ClientImpl.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_CONNECTION_POOL_SIZE = 20;
    final ClientContext clientContext;
    final boolean closeVertx;
    final HttpClient httpClient;
    final ConfigurationImpl configuration;
    final HostnameVerifier hostnameVerifier;
    final SSLContext sslContext;
    private boolean isClosed;
    final HandlerChain handlerChain;
    final Vertx vertx;
    private final MultiQueryParamMode multiQueryParamMode;
    private final String userAgent;

    public ClientImpl(HttpClientOptions options, ConfigurationImpl configuration, ClientContext clientContext, HostnameVerifier hostnameVerifier, SSLContext sslContext, boolean followRedirects, MultiQueryParamMode multiQueryParamMode, LoggingScope loggingScope, ClientLogger clientLogger, String userAgent) {
        Object shared;
        Object name;
        Object connectionPoolSize;
        Object connectionTTL;
        Object maxInitialLineLength;
        Object maxHeaderSize;
        this.userAgent = userAgent;
        this.configuration = configuration = configuration != null ? configuration : new ConfigurationImpl(RuntimeType.CLIENT);
        this.clientContext = clientContext;
        this.hostnameVerifier = hostnameVerifier;
        this.sslContext = sslContext;
        this.multiQueryParamMode = multiQueryParamMode;
        Supplier<Vertx> vertx = clientContext.getVertx();
        if (vertx != null) {
            this.vertx = vertx.get();
            this.closeVertx = false;
        } else {
            this.vertx = new LazyVertx(new Supplier<Vertx>(){

                @Override
                public Vertx get() {
                    return Vertx.vertx();
                }
            });
            this.closeVertx = true;
        }
        Object connectTimeoutMs = configuration.getProperty("io.quarkus.rest.client.connect-timeout");
        if (connectTimeoutMs == null) {
            options.setConnectTimeout(15000);
        } else {
            options.setConnectTimeout((Integer)connectTimeoutMs);
        }
        Object maxRedirects = configuration.getProperty("io.quarkus.rest.client.max-redirects");
        if (maxRedirects != null) {
            options.setMaxRedirects((Integer)maxRedirects);
        }
        if ((maxHeaderSize = configuration.getProperty("io.quarkus.rest.client.max-header-size")) != null) {
            options.setMaxHeaderSize((Integer)maxHeaderSize);
        }
        if ((maxInitialLineLength = configuration.getProperty("io.quarkus.rest.client.max-initial-line-length")) != null) {
            options.setMaxInitialLineLength((Integer)maxInitialLineLength);
        }
        if ((connectionTTL = configuration.getProperty("io.quarkus.rest.client.connection-ttl")) != null) {
            options.setKeepAliveTimeout((Integer)connectionTTL);
            options.setHttp2KeepAliveTimeout((Integer)connectionTTL);
        }
        if ((connectionPoolSize = configuration.getProperty("io.quarkus.rest.client.connection-pool-size")) == null) {
            connectionPoolSize = 20;
        } else {
            log.debugf("Setting connectionPoolSize to %d", connectionPoolSize);
        }
        options.setMaxPoolSize((Integer)connectionPoolSize);
        options.setHttp2MaxPoolSize((Integer)connectionPoolSize);
        Object keepAliveEnabled = configuration.getProperty("io.quarkus.rest.client.keep-alive-enabled");
        if (keepAliveEnabled != null) {
            Boolean enabled = (Boolean)keepAliveEnabled;
            options.setKeepAlive(enabled);
            if (!enabled.booleanValue()) {
                log.debug("keep alive disabled");
            }
        }
        if (loggingScope == LoggingScope.ALL) {
            options.setLogActivity(true);
        }
        if ((name = configuration.getProperty("io.quarkus.rest.client.name")) != null) {
            log.debugf("Setting client name to %s", name);
            options.setName((String)name);
        }
        if ((shared = configuration.getProperty("io.quarkus.rest.client.shared")) != null && ((Boolean)shared).booleanValue()) {
            log.debugf("Sharing of the HTTP client '%s' enabled", (Object)options.getName());
            options.setShared(true);
        }
        HttpClientBuilder httpClientBuilder = this.vertx.httpClientBuilder().with(options).with(options.getPoolOptions());
        AdvancedRedirectHandler advancedRedirectHandler = configuration.getFromContext(AdvancedRedirectHandler.class);
        if (advancedRedirectHandler != null) {
            httpClientBuilder.withRedirectHandler(new WrapperVertxAdvancedRedirectHandlerImpl(advancedRedirectHandler));
        } else {
            RedirectHandler redirectHandler = configuration.getFromContext(RedirectHandler.class);
            if (redirectHandler != null) {
                httpClientBuilder.withRedirectHandler(new WrapperVertxRedirectHandlerImpl(redirectHandler));
            }
        }
        this.httpClient = httpClientBuilder.build();
        if (loggingScope != LoggingScope.NONE) {
            Function<HttpClientResponse, Future<RequestOptions>> defaultRedirectHandler = this.httpClient.redirectHandler();
            this.httpClient.redirectHandler(response -> {
                clientLogger.logResponse((HttpClientResponse)response, true);
                return (Future)defaultRedirectHandler.apply((HttpClientResponse)response);
            });
        }
        this.handlerChain = new HandlerChain(this.isCaptureStacktrace(configuration), options.getMaxChunkSize(), followRedirects, loggingScope, clientContext.getMultipartResponsesData(), clientLogger);
    }

    private boolean isCaptureStacktrace(ConfigurationImpl configuration) {
        Object captureStacktraceObj = configuration.getProperty("io.quarkus.rest.client.capture-stacktrace");
        if (captureStacktraceObj == null) {
            return false;
        }
        return (Boolean)captureStacktraceObj;
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.httpClient.close();
        if (this.closeVertx) {
            this.vertx.close();
        }
        log.debug("Client is closed");
    }

    void abortIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public WebTarget target(String uri) {
        Objects.requireNonNull(uri);
        return this.target(UriBuilder.fromUri(uri));
    }

    @Override
    public WebTarget target(URI uri) {
        Objects.requireNonNull(uri);
        return this.target(UriBuilder.fromUri(uri));
    }

    @Override
    public WebTarget target(UriBuilder uriBuilder) {
        this.abortIfClosed();
        Objects.requireNonNull(uriBuilder);
        if (uriBuilder instanceof UriBuilderImpl && this.multiQueryParamMode != null) {
            ((UriBuilderImpl)uriBuilder).multiQueryParamMode(this.multiQueryParamMode);
        }
        return new WebTargetImpl(this, this.httpClient, uriBuilder, new ConfigurationImpl(this.configuration), this.handlerChain, null);
    }

    @Override
    public WebTarget target(Link link) {
        Objects.requireNonNull(link);
        return this.target(UriBuilder.fromLink(link));
    }

    @Override
    public Invocation.Builder invocation(Link link) {
        this.abortIfClosed();
        Objects.requireNonNull(link);
        Invocation.Builder request = this.target(link).request();
        if (link.getType() != null) {
            request.accept(link.getType());
        }
        return request;
    }

    @Override
    public SSLContext getSslContext() {
        this.abortIfClosed();
        return this.sslContext;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        this.abortIfClosed();
        return this.hostnameVerifier;
    }

    @Override
    public ConfigurationImpl getConfiguration() {
        this.abortIfClosed();
        return this.configuration;
    }

    @Override
    public Client property(String name, Object value) {
        this.abortIfClosed();
        this.configuration.property(name, value);
        return this;
    }

    @Override
    public Client register(Class<?> componentClass) {
        this.abortIfClosed();
        this.configuration.register(componentClass);
        return this;
    }

    @Override
    public Client register(Class<?> componentClass, int priority) {
        this.abortIfClosed();
        this.configuration.register(componentClass, priority);
        return this;
    }

    @Override
    public Client register(Class<?> componentClass, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(componentClass, contracts);
        return this;
    }

    @Override
    public Client register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(componentClass, contracts);
        return this;
    }

    @Override
    public Client register(Object component) {
        this.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    @Override
    public Client register(Object component, int priority) {
        this.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    @Override
    public Client register(Object component, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(component, contracts);
        return this;
    }

    @Override
    public Client register(Object component, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(component, contracts);
        return this;
    }

    Vertx getVertx() {
        return this.vertx;
    }

    private static class LazyVertx
    implements Vertx {
        private final Supplier<Vertx> supplier;
        private volatile Vertx supplied = null;

        LazyVertx(Supplier<Vertx> supplier) {
            this.supplier = supplier;
        }

        private Vertx getDelegate() {
            if (this.supplied == null) {
                this.supplied = this.supplier.get();
            }
            return this.supplied;
        }

        @Override
        public Context getOrCreateContext() {
            return this.getDelegate().getOrCreateContext();
        }

        @Override
        public NetServer createNetServer(NetServerOptions netServerOptions) {
            return this.getDelegate().createNetServer(netServerOptions);
        }

        @Override
        public NetServer createNetServer() {
            return this.getDelegate().createNetServer();
        }

        @Override
        public NetClient createNetClient(NetClientOptions netClientOptions) {
            return this.getDelegate().createNetClient(netClientOptions);
        }

        @Override
        public NetClient createNetClient() {
            return this.getDelegate().createNetClient();
        }

        @Override
        public HttpServer createHttpServer(HttpServerOptions httpServerOptions) {
            return this.getDelegate().createHttpServer(httpServerOptions);
        }

        @Override
        public HttpServer createHttpServer() {
            return this.getDelegate().createHttpServer();
        }

        @Override
        public WebSocketClient createWebSocketClient(WebSocketClientOptions options) {
            return this.getDelegate().createWebSocketClient(options);
        }

        @Override
        public HttpClientBuilder httpClientBuilder() {
            return this.getDelegate().httpClientBuilder();
        }

        @Override
        public HttpClient createHttpClient(final HttpClientOptions httpClientOptions) {
            return new LazyHttpClient(new Supplier<HttpClient>(){

                @Override
                public HttpClient get() {
                    return this.getDelegate().createHttpClient(httpClientOptions);
                }
            });
        }

        @Override
        public HttpClient createHttpClient() {
            return new LazyHttpClient(new Supplier<HttpClient>(){

                @Override
                public HttpClient get() {
                    return this.getDelegate().createHttpClient();
                }
            });
        }

        @Override
        public DatagramSocket createDatagramSocket(DatagramSocketOptions datagramSocketOptions) {
            return this.getDelegate().createDatagramSocket(datagramSocketOptions);
        }

        @Override
        public DatagramSocket createDatagramSocket() {
            return this.getDelegate().createDatagramSocket();
        }

        @Override
        public FileSystem fileSystem() {
            return this.getDelegate().fileSystem();
        }

        @Override
        public EventBus eventBus() {
            return this.getDelegate().eventBus();
        }

        @Override
        public DnsClient createDnsClient(int i, String s) {
            return this.getDelegate().createDnsClient(i, s);
        }

        @Override
        public DnsClient createDnsClient() {
            return this.getDelegate().createDnsClient();
        }

        @Override
        public DnsClient createDnsClient(DnsClientOptions dnsClientOptions) {
            return this.getDelegate().createDnsClient(dnsClientOptions);
        }

        @Override
        public SharedData sharedData() {
            return this.getDelegate().sharedData();
        }

        @Override
        public Timer timer(long delay, TimeUnit unit) {
            return this.getDelegate().timer(delay, unit);
        }

        @Override
        public long setTimer(long l, Handler<Long> handler) {
            return this.getDelegate().setTimer(l, handler);
        }

        @Override
        public TimeoutStream timerStream(long l) {
            return this.getDelegate().timerStream(l);
        }

        @Override
        public long setPeriodic(long l, Handler<Long> handler) {
            return this.getDelegate().setPeriodic(l, handler);
        }

        @Override
        public long setPeriodic(long initialDelay, long delay, Handler<Long> handler) {
            return this.getDelegate().setPeriodic(initialDelay, delay, handler);
        }

        @Override
        public TimeoutStream periodicStream(long l) {
            return this.getDelegate().periodicStream(l);
        }

        @Override
        public TimeoutStream periodicStream(long initialDelay, long delay) {
            return this.getDelegate().periodicStream(initialDelay, delay);
        }

        @Override
        public boolean cancelTimer(long l) {
            return this.getDelegate().cancelTimer(l);
        }

        @Override
        public void runOnContext(Handler<Void> handler) {
            this.getDelegate().runOnContext(handler);
        }

        @Override
        public Future<Void> close() {
            if (this.supplied != null) {
                return this.getDelegate().close();
            }
            return Future.succeededFuture();
        }

        @Override
        public void close(Handler<AsyncResult<Void>> handler) {
            if (this.supplied != null) {
                this.getDelegate().close(handler);
            }
        }

        @Override
        public Future<String> deployVerticle(Verticle verticle) {
            return this.getDelegate().deployVerticle(verticle);
        }

        @Override
        public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> handler) {
            this.getDelegate().deployVerticle(verticle, handler);
        }

        public static Vertx vertx() {
            return Vertx.vertx();
        }

        public static Vertx vertx(VertxOptions options) {
            return Vertx.vertx(options);
        }

        public static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
            Vertx.clusteredVertx(options, resultHandler);
        }

        public static Future<Vertx> clusteredVertx(VertxOptions options) {
            return Vertx.clusteredVertx(options);
        }

        public static Context currentContext() {
            return Vertx.currentContext();
        }

        @Override
        public Future<String> deployVerticle(Verticle verticle, DeploymentOptions options) {
            return this.getDelegate().deployVerticle(verticle, options);
        }

        @Override
        public Future<String> deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options) {
            return this.getDelegate().deployVerticle(verticleClass, options);
        }

        @Override
        public Future<String> deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
            return this.getDelegate().deployVerticle(verticleSupplier, options);
        }

        @Override
        public void deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(verticle, options, completionHandler);
        }

        @Override
        public void deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(verticleClass, options, completionHandler);
        }

        @Override
        public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(verticleSupplier, options, completionHandler);
        }

        @Override
        public Future<String> deployVerticle(String name) {
            return this.getDelegate().deployVerticle(name);
        }

        @Override
        public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(name, completionHandler);
        }

        @Override
        public Future<String> deployVerticle(String name, DeploymentOptions options) {
            return this.getDelegate().deployVerticle(name, options);
        }

        @Override
        public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(name, options, completionHandler);
        }

        @Override
        public Future<Void> undeploy(String deploymentID) {
            return this.getDelegate().undeploy(deploymentID);
        }

        @Override
        public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
            this.getDelegate().undeploy(deploymentID, completionHandler);
        }

        @Override
        public Set<String> deploymentIDs() {
            return this.getDelegate().deploymentIDs();
        }

        @Override
        public void registerVerticleFactory(VerticleFactory factory) {
            this.getDelegate().registerVerticleFactory(factory);
        }

        @Override
        public void unregisterVerticleFactory(VerticleFactory factory) {
            this.getDelegate().unregisterVerticleFactory(factory);
        }

        @Override
        public Set<VerticleFactory> verticleFactories() {
            return this.getDelegate().verticleFactories();
        }

        @Override
        public boolean isClustered() {
            return this.getDelegate().isClustered();
        }

        @Override
        @Deprecated
        public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
            this.getDelegate().executeBlocking(blockingCodeHandler, ordered, asyncResultHandler);
        }

        @Override
        @Deprecated
        public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> asyncResultHandler) {
            this.getDelegate().executeBlocking(blockingCodeHandler, asyncResultHandler);
        }

        @Override
        @Deprecated
        public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
            return this.getDelegate().executeBlocking(blockingCodeHandler, ordered);
        }

        @Override
        public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
            return this.getDelegate().executeBlocking(blockingCodeHandler);
        }

        @Override
        public EventLoopGroup nettyEventLoopGroup() {
            return this.getDelegate().nettyEventLoopGroup();
        }

        @Override
        public WorkerExecutor createSharedWorkerExecutor(String name) {
            return this.getDelegate().createSharedWorkerExecutor(name);
        }

        @Override
        public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize) {
            return this.getDelegate().createSharedWorkerExecutor(name, poolSize);
        }

        @Override
        public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
            return this.getDelegate().createSharedWorkerExecutor(name, poolSize, maxExecuteTime);
        }

        @Override
        public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
            return this.getDelegate().createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit);
        }

        @Override
        public boolean isNativeTransportEnabled() {
            return this.getDelegate().isNativeTransportEnabled();
        }

        @Override
        public Throwable unavailableNativeTransportCause() {
            return this.getDelegate().unavailableNativeTransportCause();
        }

        @Override
        public Vertx exceptionHandler(Handler<Throwable> handler) {
            return this.getDelegate().exceptionHandler(handler);
        }

        @Override
        public Handler<Throwable> exceptionHandler() {
            return this.getDelegate().exceptionHandler();
        }

        @Override
        public boolean isMetricsEnabled() {
            return this.getDelegate().isMetricsEnabled();
        }

        private static class LazyHttpClient
        implements HttpClient {
            private final Supplier<HttpClient> supplier;
            private volatile HttpClient supplied = null;

            LazyHttpClient(Supplier<HttpClient> supplier) {
                this.supplier = supplier;
            }

            private HttpClient getDelegate() {
                if (this.supplied == null) {
                    this.supplied = this.supplier.get();
                }
                return this.supplied;
            }

            @Override
            public void request(RequestOptions options, Handler<AsyncResult<HttpClientRequest>> handler) {
                this.getDelegate().request(options, handler);
            }

            @Override
            public Future<HttpClientRequest> request(RequestOptions options) {
                return this.getDelegate().request(options);
            }

            @Override
            public void request(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
                this.getDelegate().request(method, port, host, requestURI, handler);
            }

            @Override
            public Future<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
                return this.getDelegate().request(method, port, host, requestURI);
            }

            @Override
            public void request(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
                this.getDelegate().request(method, host, requestURI, handler);
            }

            @Override
            public Future<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
                return this.getDelegate().request(method, host, requestURI);
            }

            @Override
            public void request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
                this.getDelegate().request(method, requestURI, handler);
            }

            @Override
            public Future<HttpClientRequest> request(HttpMethod method, String requestURI) {
                return this.getDelegate().request(method, requestURI);
            }

            @Override
            public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(port, host, requestURI, handler);
            }

            @Override
            public Future<WebSocket> webSocket(int port, String host, String requestURI) {
                return this.getDelegate().webSocket(port, host, requestURI);
            }

            @Override
            public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(host, requestURI, handler);
            }

            @Override
            public Future<WebSocket> webSocket(String host, String requestURI) {
                return this.getDelegate().webSocket(host, requestURI);
            }

            @Override
            public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(requestURI, handler);
            }

            @Override
            public Future<WebSocket> webSocket(String requestURI) {
                return this.getDelegate().webSocket(requestURI);
            }

            @Override
            public void webSocket(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(options, handler);
            }

            @Override
            public Future<WebSocket> webSocket(WebSocketConnectOptions options) {
                return this.getDelegate().webSocket(options);
            }

            @Override
            public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocketAbs(url, headers, version, subProtocols, handler);
            }

            @Override
            public Future<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
                return this.getDelegate().webSocketAbs(url, headers, version, subProtocols);
            }

            @Override
            public Future<Boolean> updateSSLOptions(SSLOptions options) {
                return this.getDelegate().updateSSLOptions(options);
            }

            @Override
            public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
                this.getDelegate().updateSSLOptions(options, handler);
            }

            @Override
            public Future<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
                return this.getDelegate().updateSSLOptions(options, force);
            }

            @Override
            public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
                this.getDelegate().updateSSLOptions(options, force, handler);
            }

            @Override
            public HttpClient connectionHandler(Handler<HttpConnection> handler) {
                return this.getDelegate().connectionHandler(handler);
            }

            @Override
            public HttpClient redirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
                return this.getDelegate().redirectHandler(handler);
            }

            @Override
            public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
                return this.getDelegate().redirectHandler();
            }

            @Override
            public void close(Handler<AsyncResult<Void>> handler) {
                if (this.supplied != null) {
                    this.getDelegate().close(handler);
                }
                if (handler != null) {
                    handler.handle(Future.succeededFuture());
                }
            }

            @Override
            public Future<Void> close() {
                if (this.supplied != null) {
                    return this.getDelegate().close();
                }
                return Future.succeededFuture();
            }

            @Override
            public boolean isMetricsEnabled() {
                return this.getDelegate().isMetricsEnabled();
            }
        }
    }
}

