/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;

public class ClientRequestHeaders {
    protected CaseInsensitiveMap<Object> headers = new CaseInsensitiveMap();
    protected ConfigurationImpl configuration;

    public ClientRequestHeaders(ConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    public CaseInsensitiveMap<Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultivaluedMap<String, Object> newHeaders) {
        this.headers.clear();
        if (newHeaders == null) {
            return;
        }
        this.headers.putAll(newHeaders);
    }

    public void setLanguage(Locale language) {
        if (this.getHeader("Content-Language") != null) {
            return;
        }
        if (language == null) {
            this.headers.remove("Content-Language");
            return;
        }
        this.headers.putSingle("Content-Language", language);
    }

    public void setLanguage(String language) {
        this.setLanguage(new Locale(language));
    }

    public void setMediaType(MediaType mediaType) {
        if (mediaType == null) {
            this.headers.remove("Content-Type");
            return;
        }
        this.headers.putSingle("Content-Type", mediaType);
    }

    public void acceptLanguage(Locale ... locales) {
        String accept = (String)this.headers.getFirst("Accept-Language");
        StringBuilder builder = this.buildAcceptString(accept, locales);
        this.headers.putSingle("Accept-Language", builder.toString());
    }

    public void acceptLanguage(String ... locales) {
        String accept = (String)this.headers.getFirst("Accept-Language");
        StringBuilder builder = this.buildAcceptString(accept, locales);
        this.headers.putSingle("Accept-Language", builder.toString());
    }

    private StringBuilder buildAcceptString(String accept, Object[] items) {
        StringBuilder builder = new StringBuilder();
        if (accept != null) {
            builder.append(accept).append(", ");
        }
        boolean isFirst = true;
        for (Object l : items) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(HeaderUtil.headerToString(l));
        }
        return builder;
    }

    public void acceptEncoding(String ... encodings) {
        String accept = (String)this.headers.getFirst("Accept-Encoding");
        StringBuilder builder = this.buildAcceptString(accept, encodings);
        this.headers.putSingle("Accept-Encoding", builder.toString());
    }

    public void accept(String ... types) {
        String accept = (String)this.headers.getFirst("Accept");
        StringBuilder builder = this.buildAcceptString(accept, types);
        this.headers.putSingle("Accept", builder.toString());
    }

    public void accept(MediaType ... types) {
        String accept = (String)this.headers.getFirst("Accept");
        StringBuilder builder = this.buildAcceptString(accept, types);
        this.headers.putSingle("Accept", builder.toString());
    }

    public void cookie(Cookie cookie) {
        if (!Cookie.class.equals(cookie.getClass())) {
            cookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion());
        }
        this.headers.add("Cookie", cookie);
    }

    public void allow(String ... methods) {
        HeaderUtil.setAllow(this.headers, methods);
    }

    public void allow(Set<String> methods) {
        HeaderUtil.setAllow(this.headers, methods);
    }

    public void cacheControl(CacheControl cacheControl) {
        this.headers.putSingle("Cache-Control", cacheControl);
    }

    public void header(String name, Object value) {
        if (value == null) {
            this.headers.remove(name);
            return;
        }
        if (name.equalsIgnoreCase("Accept")) {
            this.accept(HeaderUtil.headerToString(value));
        } else if (name.equalsIgnoreCase("Accept-Encoding")) {
            this.acceptEncoding(HeaderUtil.headerToString(value));
        } else if (name.equalsIgnoreCase("Accept-Language")) {
            this.acceptLanguage(HeaderUtil.headerToString(value));
        } else {
            this.headers.add(name, value);
        }
    }

    public Date getDate() {
        return HeaderUtil.getDate(this.headers);
    }

    public String getHeader(String name) {
        return HeaderUtil.getHeaderString(this.headers, name);
    }

    public MultivaluedMap<String, String> asMap() {
        CaseInsensitiveMap<String> map = new CaseInsensitiveMap<String>();
        for (Map.Entry entry : this.headers.entrySet()) {
            for (Object obj : entry.getValue()) {
                map.add((String)entry.getKey(), HeaderUtil.headerToString(obj));
            }
        }
        return map;
    }

    public Locale getLanguage() {
        return HeaderUtil.getLanguage(this.headers);
    }

    public int getLength() {
        return HeaderUtil.getLength(this.headers);
    }

    public MediaType getMediaType() {
        return HeaderUtil.getMediaType(this.headers);
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return HeaderUtil.getAcceptableMediaTypes(this.headers);
    }

    public List<Locale> getAcceptableLanguages() {
        return HeaderUtil.getAcceptableLanguages(this.headers);
    }

    public Map<String, Cookie> getCookies() {
        return HeaderUtil.getCookies(this.headers);
    }
}

