/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.headers.LinkHeaders;
import org.jboss.resteasy.reactive.common.jaxrs.StatusTypeImpl;

public class ClientResponseContextImpl
implements ClientResponseContext {
    private final RestClientRequestContext state;

    public ClientResponseContextImpl(RestClientRequestContext state) {
        this.state = state;
    }

    public String getReasonPhrase() {
        return this.state.getResponseReasonPhrase();
    }

    public ClientResponseContextImpl setReasonPhrase(String reasonPhrase) {
        this.state.setResponseReasonPhrase(reasonPhrase);
        return this;
    }

    public ClientResponseContextImpl setHeaders(MultivaluedMap<String, String> headers) {
        this.state.setResponseHeaders(headers);
        return this;
    }

    @Override
    public int getStatus() {
        return this.state.getResponseStatus();
    }

    @Override
    public void setStatus(int code) {
        this.state.setResponseStatus(code);
    }

    @Override
    public Response.StatusType getStatusInfo() {
        return new StatusTypeImpl(this.state.getResponseStatus(), this.state.getResponseReasonPhrase());
    }

    @Override
    public void setStatusInfo(Response.StatusType statusInfo) {
        this.state.setResponseStatus(statusInfo.getStatusCode()).setResponseReasonPhrase(statusInfo.getReasonPhrase());
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.state.getResponseHeaders();
    }

    @Override
    public String getHeaderString(String name) {
        return HeaderUtil.getHeaderString(this.state.getResponseHeaders(), name);
    }

    @Override
    public Set<String> getAllowedMethods() {
        return HeaderUtil.getAllowedMethods(this.state.getResponseHeaders());
    }

    @Override
    public Date getDate() {
        return HeaderUtil.getDate(this.state.getResponseHeaders());
    }

    @Override
    public Locale getLanguage() {
        return HeaderUtil.getLanguage(this.state.getResponseHeaders());
    }

    @Override
    public int getLength() {
        return HeaderUtil.getLength(this.state.getResponseHeaders());
    }

    @Override
    public MediaType getMediaType() {
        return HeaderUtil.getMediaType(this.state.getResponseHeaders());
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        return HeaderUtil.getNewCookies(this.state.getResponseHeaders());
    }

    @Override
    public EntityTag getEntityTag() {
        return HeaderUtil.getEntityTag(this.state.getResponseHeaders());
    }

    @Override
    public Date getLastModified() {
        return HeaderUtil.getLastModified(this.state.getResponseHeaders());
    }

    @Override
    public URI getLocation() {
        return HeaderUtil.getLocation(this.state.getResponseHeaders());
    }

    private LinkHeaders getLinkHeaders() {
        return new LinkHeaders(this.state.getResponseHeaders());
    }

    @Override
    public Set<Link> getLinks() {
        return new HashSet<Link>(this.getLinkHeaders().getLinks());
    }

    @Override
    public boolean hasLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation) != null;
    }

    @Override
    public Link getLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation);
    }

    @Override
    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLinkHeaders().getLinkByRelationship(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink(link);
    }

    @Override
    public boolean hasEntity() {
        return this.state.getResponseEntityStream() != null;
    }

    @Override
    public InputStream getEntityStream() {
        return this.state.getResponseEntityStream();
    }

    @Override
    public void setEntityStream(InputStream input) {
        this.state.setResponseEntityStream(input);
    }
}

