/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.Context;
import io.vertx.core.http.HttpClient;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.CompletionStageRxInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.RxInvoker;
import jakarta.ws.rs.client.RxInvokerProvider;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.ClientRequestHeaders;
import org.jboss.resteasy.reactive.client.impl.HandlerChain;
import org.jboss.resteasy.reactive.client.impl.InvocationImpl;
import org.jboss.resteasy.reactive.client.impl.MultiInvoker;
import org.jboss.resteasy.reactive.client.impl.RequestSpec;
import org.jboss.resteasy.reactive.client.impl.UniInvoker;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.common.core.BlockingNotAllowedException;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class InvocationBuilderImpl
implements Invocation.Builder {
    final URI uri;
    final HttpClient httpClient;
    final WebTargetImpl target;
    final RequestSpec requestSpec;
    final Map<String, Object> properties = new HashMap<String, Object>();
    final ConfigurationImpl configuration;
    final ClientImpl restClient;
    final HandlerChain handlerChain;
    final ThreadSetupAction requestContext;

    public InvocationBuilderImpl(URI uri, ClientImpl restClient, HttpClient httpClient, WebTargetImpl target, ConfigurationImpl configuration, HandlerChain handlerChain, ThreadSetupAction requestContext) {
        this.uri = uri;
        this.restClient = restClient;
        this.httpClient = httpClient;
        this.target = target;
        this.requestSpec = new RequestSpec(configuration);
        this.configuration = configuration;
        this.handlerChain = handlerChain;
        this.requestContext = requestContext;
    }

    @Override
    public Invocation build(String method) {
        this.setUserAgentIfNotSet();
        return new InvocationImpl(method, this.async(), null);
    }

    @Override
    public Invocation build(String method, Entity<?> entity) {
        this.setUserAgentIfNotSet();
        return new InvocationImpl(method, this.async(), entity);
    }

    @Override
    public Invocation buildGet() {
        return this.build("GET");
    }

    @Override
    public Invocation buildDelete() {
        return this.build("DELETE");
    }

    @Override
    public Invocation buildPost(Entity<?> entity) {
        return this.build("POST", entity);
    }

    @Override
    public Invocation buildPut(Entity<?> entity) {
        return this.build("PUT", entity);
    }

    @Override
    public AsyncInvokerImpl async() {
        this.setUserAgentIfNotSet();
        return new AsyncInvokerImpl(this.restClient, this.httpClient, this.uri, this.requestSpec, this.configuration, this.properties, this.handlerChain, this.requestContext);
    }

    @Override
    public Invocation.Builder accept(String ... mediaTypes) {
        this.requestSpec.headers.accept(mediaTypes);
        return this;
    }

    @Override
    public Invocation.Builder accept(MediaType ... mediaTypes) {
        this.requestSpec.headers.accept(mediaTypes);
        return this;
    }

    @Override
    public Invocation.Builder acceptLanguage(Locale ... locales) {
        this.requestSpec.headers.acceptLanguage(locales);
        return this;
    }

    @Override
    public Invocation.Builder acceptLanguage(String ... locales) {
        this.requestSpec.headers.acceptLanguage(locales);
        return this;
    }

    @Override
    public Invocation.Builder acceptEncoding(String ... encodings) {
        this.requestSpec.headers.acceptEncoding(encodings);
        return this;
    }

    @Override
    public Invocation.Builder cookie(Cookie cookie) {
        this.requestSpec.headers.cookie(cookie);
        return this;
    }

    @Override
    public Invocation.Builder cookie(String name, String value) {
        this.requestSpec.headers.cookie(new Cookie(name, value));
        return this;
    }

    @Override
    public Invocation.Builder cacheControl(CacheControl cacheControl) {
        this.requestSpec.headers.cacheControl(cacheControl);
        return this;
    }

    @Override
    public Invocation.Builder header(String name, Object value) {
        this.requestSpec.headers.header(name, value);
        return this;
    }

    @Override
    public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
        this.requestSpec.headers.setHeaders(headers);
        return this;
    }

    @Override
    public Invocation.Builder property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public CompletionStageRxInvoker rx() {
        return new AsyncInvokerImpl(this.restClient, this.httpClient, this.uri, this.requestSpec, this.configuration, this.properties, this.handlerChain, this.requestContext);
    }

    @Override
    public <T extends RxInvoker> T rx(Class<T> clazz) {
        this.setUserAgentIfNotSet();
        if (clazz == MultiInvoker.class) {
            return (T)new MultiInvoker(this);
        }
        if (clazz == UniInvoker.class) {
            return (T)new UniInvoker(this);
        }
        RxInvokerProvider<?> invokerProvider = this.requestSpec.configuration.getRxInvokerProvider(clazz);
        if (invokerProvider != null) {
            return (T)invokerProvider.getRxInvoker(this, null);
        }
        return null;
    }

    private void setUserAgentIfNotSet() {
        if (!this.requestSpec.headers.getHeaders().containsKey("User-Agent") && this.restClient.getUserAgent() != null && !this.restClient.getUserAgent().isEmpty()) {
            this.requestSpec.headers.header("User-Agent", this.restClient.getUserAgent());
        }
    }

    @Override
    public Response get() {
        return (Response)this.unwrap((CompletableFuture)this.async().get());
    }

    private <T> T unwrap(CompletableFuture<T> c) {
        if (Context.isOnEventLoopThread()) {
            throw new BlockingNotAllowedException();
        }
        try {
            return c.get();
        }
        catch (InterruptedException e) {
            throw new ProcessingException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ProcessingException) {
                throw (ProcessingException)e.getCause();
            }
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new ProcessingException(e.getCause().getMessage(), e.getCause());
        }
    }

    @Override
    public <T> T get(Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().get((Class)responseType));
    }

    @Override
    public <T> T get(GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().get((GenericType)responseType));
    }

    @Override
    public Response put(Entity<?> entity) {
        return (Response)this.unwrap((CompletableFuture)this.async().put((Entity)entity));
    }

    @Override
    public <T> T put(Entity<?> entity, Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().put((Entity)entity, (Class)responseType));
    }

    @Override
    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().put((Entity)entity, (GenericType)responseType));
    }

    @Override
    public Response post(Entity<?> entity) {
        return (Response)this.unwrap((CompletableFuture)this.async().post((Entity)entity));
    }

    @Override
    public <T> T post(Entity<?> entity, Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().post((Entity)entity, (Class)responseType));
    }

    @Override
    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().post((Entity)entity, (GenericType)responseType));
    }

    @Override
    public Response delete() {
        return (Response)this.unwrap((CompletableFuture)this.async().delete());
    }

    @Override
    public <T> T delete(Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().delete((Class)responseType));
    }

    @Override
    public <T> T delete(GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().delete((GenericType)responseType));
    }

    @Override
    public Response head() {
        return (Response)this.unwrap((CompletableFuture)this.async().head());
    }

    @Override
    public Response options() {
        return (Response)this.unwrap((CompletableFuture)this.async().options());
    }

    @Override
    public <T> T options(Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().options((Class)responseType));
    }

    @Override
    public <T> T options(GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().options((GenericType)responseType));
    }

    @Override
    public Response trace() {
        return (Response)this.unwrap((CompletableFuture)this.async().trace());
    }

    @Override
    public <T> T trace(Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().trace((Class)responseType));
    }

    @Override
    public <T> T trace(GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().trace((GenericType)responseType));
    }

    @Override
    public Response method(String name) {
        return (Response)this.unwrap((CompletableFuture)this.async().method(name));
    }

    @Override
    public <T> T method(String name, Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().method(name, (Class)responseType));
    }

    @Override
    public <T> T method(String name, GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().method(name, (GenericType)responseType));
    }

    @Override
    public Response method(String name, Entity<?> entity) {
        return (Response)this.unwrap((CompletableFuture)this.async().method(name, (Entity)entity));
    }

    @Override
    public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().method(name, (Entity)entity, (Class)responseType));
    }

    @Override
    public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.unwrap((CompletableFuture<T>)this.async().method(name, (Entity)entity, (GenericType)responseType));
    }

    public WebTargetImpl getTarget() {
        return this.target;
    }

    public void setChunked(boolean chunked) {
        this.requestSpec.chunked = chunked;
    }

    public boolean getChunked() {
        return this.requestSpec.chunked;
    }

    public ClientRequestHeaders getHeaders() {
        return this.requestSpec.headers;
    }
}

