/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;

public class ProvidersImpl
implements Providers {
    private final RestClientRequestContext context;

    public ProvidersImpl(RestClientRequestContext context) {
        this.context = context;
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<MessageBodyReader<?>> readers = this.context.getRestClient().getClientContext().getSerialisers().findReaders(this.context.getConfiguration(), type, mediaType, RuntimeType.CLIENT);
        for (MessageBodyReader<T> messageBodyReader : readers) {
            if (!messageBodyReader.isReadable(type, genericType, annotations, mediaType)) continue;
            return messageBodyReader;
        }
        return null;
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<MessageBodyWriter<?>> writers = this.context.getRestClient().getClientContext().getSerialisers().findWriters(this.context.getConfiguration(), type, mediaType, RuntimeType.CLIENT);
        for (MessageBodyWriter<T> messageBodyWriter : writers) {
            if (!messageBodyWriter.isWriteable(type, genericType, annotations, mediaType)) continue;
            return messageBodyWriter;
        }
        return null;
    }

    @Override
    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        throw new UnsupportedOperationException("`jakarta.ws.rs.ext.ExceptionMapper` are not supported in REST Client Reactive");
    }

    @Override
    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return this.context.getConfiguration().getContextResolver(contextType);
    }
}

