/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.function.Function;
import org.jboss.resteasy.reactive.client.handlers.RedirectHandler;
import org.jboss.resteasy.reactive.client.impl.RedirectUtil;

class WrapperVertxRedirectHandlerImpl
implements Function<HttpClientResponse, Future<RequestOptions>> {
    private final RedirectHandler redirectHandler;

    WrapperVertxRedirectHandlerImpl(RedirectHandler redirectHandler) {
        this.redirectHandler = redirectHandler;
    }

    @Override
    public Future<RequestOptions> apply(HttpClientResponse httpClientResponse) {
        Response jaxRsResponse = RedirectUtil.toResponse(httpClientResponse);
        URI newLocation = this.redirectHandler.handle(jaxRsResponse);
        if (newLocation != null) {
            RequestOptions options = new RequestOptions();
            options.setAbsoluteURI(newLocation.toString());
            if (httpClientResponse.statusCode() == 307) {
                options.setMethod(httpClientResponse.request().getMethod());
            }
            return Future.succeededFuture(options);
        }
        return null;
    }
}

