/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl.multipart;

import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.IOException;
import java.nio.file.Path;
import org.jboss.resteasy.reactive.multipart.FileDownload;

public class FileDownloadImpl
implements FileDownload {
    private final FileUpload file;

    public FileDownloadImpl(FileUpload httpData) {
        this.file = httpData;
    }

    @Override
    public String name() {
        return this.file.getName();
    }

    @Override
    public Path filePath() {
        try {
            return this.file == null ? null : this.file.getFile().toPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to provide file for download", e);
        }
    }

    @Override
    public String fileName() {
        return this.file.getFilename();
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("returning size of a downloaded file is not supported");
    }

    @Override
    public String contentType() {
        return this.file.getContentType();
    }

    @Override
    public String charSet() {
        return this.file.getCharset().name();
    }
}

